/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.infernalstudios.infernalexp.access.FireTypeAccess;
import org.infernalstudios.infernalexp.api.FireType;
import org.infernalstudios.infernalexp.init.IEFireTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements FireTypeAccess {
    @Shadow
    @Final
    protected EntityDataManager field_70180_af;
    @Unique
    private static final DataParameter<String> FIRE_TYPE = EntityDataManager.func_187226_a(Entity.class, (IDataSerializer)DataSerializers.field_187194_d);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void IE_init(EntityType<?> entityTypeIn, World worldIn, CallbackInfo ci) {
        this.field_70180_af.func_187214_a(FIRE_TYPE, (Object)IEFireTypes.FIRE.getName().toString());
    }

    @Inject(method={"writeWithoutTypeId"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;putShort(Ljava/lang/String;S)V", ordinal=0, shift=At.Shift.AFTER)})
    private void IE_writeCustomFires(CompoundNBT tag, CallbackInfoReturnable<CompoundNBT> ci) {
        tag.func_74778_a("fireType", this.getFireType().getName().toString());
    }

    @Inject(method={"read"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;getShort(Ljava/lang/String;)S", ordinal=0, shift=At.Shift.AFTER)})
    private void IE_readCustomFires(CompoundNBT tag, CallbackInfo ci) {
        this.setFireType(FireType.getOrDefault(new ResourceLocation(tag.func_74779_i("fireType")), IEFireTypes.FIRE));
    }

    @Inject(method={"setFire"}, at={@At(value="HEAD")})
    private void IE_setToDefaultFireType(int seconds, CallbackInfo ci) {
        this.setFireType(IEFireTypes.FIRE);
    }

    @Override
    public FireType getFireType() {
        return FireType.getOrDefault(new ResourceLocation((String)this.field_70180_af.func_187225_a(FIRE_TYPE)), IEFireTypes.FIRE);
    }

    @Override
    public void setFireType(FireType type) {
        this.field_70180_af.func_187227_b(FIRE_TYPE, (Object)type.getName().toString());
    }
}

