/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.infernalstudios.infernalexp.world.gen.structures.BastionOutpostStructure;
import org.infernalstudios.infernalexp.world.gen.structures.GlowstoneCanyonRuinStructure;
import org.infernalstudios.infernalexp.world.gen.structures.IEStructure;
import org.infernalstudios.infernalexp.world.gen.structures.SoulSandValleyRuinStructure;
import org.infernalstudios.infernalexp.world.gen.structures.StriderAltarStructure;

public class IEStructures {
    public static List<IEStructure<?>> structures = new ArrayList();
    public static final IEStructure<NoFeatureConfig> GLOWSTONE_CANYON_RUIN = IEStructures.registerStructure("glowstone_canyon_ruin", new GlowstoneCanyonRuinStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final IEStructure<NoFeatureConfig> BASTION_OUTPOST = IEStructures.registerStructure("bastion_outpost", new BastionOutpostStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final IEStructure<NoFeatureConfig> SOUL_SAND_VALLEY_RUIN = IEStructures.registerStructure("soul_sand_valley_ruin", new SoulSandValleyRuinStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final IEStructure<NoFeatureConfig> STRIDER_ALTAR = IEStructures.registerStructure("strider_altar", new StriderAltarStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static <C extends IFeatureConfig, F extends IEStructure<C>> F registerStructure(String registryName, F structure) {
        ResourceLocation resourceLocation = new ResourceLocation("infernalexp", registryName);
        if (Registry.field_218361_B.func_148742_b().contains(resourceLocation)) {
            throw new IllegalStateException("Structure ID: \"" + resourceLocation.toString() + "\" is already in the registry!");
        }
        structure.setRegistryName(resourceLocation);
        structures.add(structure);
        return structure;
    }

    public static void setupStructures() {
        structures.forEach(structure -> IEStructures.setupMapSpacingAndLand(structure, structure.getSeparationSettings(), structure.shouldTransformLand()));
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

