/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ServerWorld;
import org.infernalstudios.infernalexp.util.NetherTeleportCommandUtil;

public class IECommands {
    private static void netherSpawnCommand(CommandDispatcher<CommandSource> dispatcher) {
        String commandString = "setdimensionspawn";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).requires(commandSource -> commandSource.func_197034_c(2))).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            BlockPos pos = player.func_233580_cy_();
            World world = player.func_130014_f_();
            String dimension = world.func_234923_W_().func_240901_a_().toString();
            player.func_242111_a(world.func_234923_W_(), pos, 0.0f, true, false);
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("infernalexp.commands.setdimensionspawn.success.single", new Object[]{player.func_145748_c_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(0.0f), dimension}), true);
            return 1;
        })).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(command -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)command, (String)"players");
            BlockPos pos = ((CommandSource)command.getSource()).func_197035_h().func_233580_cy_();
            World world = ((CommandSource)command.getSource()).func_197035_h().func_130014_f_();
            String dimension = world.func_234923_W_().func_240901_a_().toString();
            for (ServerPlayerEntity player : players) {
                player.func_242111_a(world.func_234923_W_(), pos, 0.0f, true, false);
            }
            if (players.size() == 1) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("infernalexp.commands.setdimensionspawn.success.single", new Object[]{((ServerPlayerEntity)players.iterator().next()).func_145748_c_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(0.0f), dimension}), true);
            } else {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("infernalexp.commands.setdimensionspawn.success.multiple", new Object[]{players.size(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(0.0f), dimension}), true);
            }
            return players.size();
        })));
    }

    private static void dimensionTeleportCommand(CommandDispatcher<CommandSource> dispatcher) {
        String commandString = "ntp";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).requires(commandSource -> commandSource.func_197034_c(3))).executes(command -> {
            ServerPlayerEntity player = ((CommandSource)command.getSource()).func_197035_h();
            MinecraftServer server = ((CommandSource)command.getSource()).func_197028_i();
            ServerWorld targetWorld = player.func_130014_f_().func_234923_W_() == World.field_234919_h_ ? server.func_71218_a(World.field_234918_g_) : server.func_71218_a(World.field_234919_h_);
            WorldBorder worldborder = targetWorld.func_175723_af();
            double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
            double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
            double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
            double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
            double coordinateDifference = DimensionType.func_242715_a((DimensionType)player.field_70170_p.func_230315_m_(), (DimensionType)targetWorld.func_230315_m_());
            BlockPos baseTeleportLocation = new BlockPos(MathHelper.func_151237_a((double)(player.func_226277_ct_() * coordinateDifference), (double)minX, (double)maxX), player.func_226278_cu_(), MathHelper.func_151237_a((double)(player.func_226281_cx_() * coordinateDifference), (double)minZ, (double)maxZ));
            BlockPos safeTeleportLocation = NetherTeleportCommandUtil.getSafePosition(targetWorld, baseTeleportLocation);
            if (safeTeleportLocation == null) {
                return 0;
            }
            player.func_200619_a(targetWorld, (double)safeTeleportLocation.func_177958_n(), (double)safeTeleportLocation.func_177956_o(), (double)safeTeleportLocation.func_177952_p(), player.func_195046_g(0.0f), player.func_195050_f(0.0f));
            return 1;
        }));
    }

    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher) {
        IECommands.dimensionTeleportCommand(dispatcher);
        IECommands.netherSpawnCommand(dispatcher);
    }
}

