/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.events;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.data.SpawnrateManager;
import org.infernalstudios.infernalexp.entities.BasaltGiantEntity;
import org.infernalstudios.infernalexp.entities.BlackstoneDwarfEntity;
import org.infernalstudios.infernalexp.entities.EmbodyEntity;
import org.infernalstudios.infernalexp.entities.GlowsquitoEntity;
import org.infernalstudios.infernalexp.entities.VolineEntity;
import org.infernalstudios.infernalexp.entities.WarpbeetleEntity;
import org.infernalstudios.infernalexp.entities.ai.AvoidBlockGoal;
import org.infernalstudios.infernalexp.events.MiscEvents;
import org.infernalstudios.infernalexp.init.IETags;

@Mod.EventBusSubscriber(modid="infernalexp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEvents {
    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PiglinEntity) {
            if (InfernalExpansionConfig.MobInteractions.PIGLIN_FEAR_WARPBEETLE.getBoolean()) {
                ((PiglinEntity)event.getEntity()).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)((PiglinEntity)event.getEntity()), WarpbeetleEntity.class, 16.0f, 1.2, 1.2));
            }
            if (InfernalExpansionConfig.MobInteractions.PIGLIN_FEAR_EMBODY.getBoolean()) {
                ((PiglinEntity)event.getEntity()).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)((PiglinEntity)event.getEntity()), EmbodyEntity.class, 16.0f, 1.2, 1.2));
            }
            if (InfernalExpansionConfig.MobInteractions.PIGLIN_FEAR_DWARF.getBoolean()) {
                ((PiglinEntity)event.getEntity()).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)((PiglinEntity)event.getEntity()), BlackstoneDwarfEntity.class, 16.0f, 1.2, 1.2));
            }
        }
        if (event.getEntity() instanceof HoglinEntity) {
            if (InfernalExpansionConfig.MobInteractions.HOGLIN_FEAR_WARPBEETLE.getBoolean()) {
                ((HoglinEntity)event.getEntity()).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)((HoglinEntity)event.getEntity()), WarpbeetleEntity.class, 16.0f, 1.2, 1.2));
            }
            if (InfernalExpansionConfig.MobInteractions.HOGLIN_FEAR_EMBODY.getBoolean()) {
                ((HoglinEntity)event.getEntity()).field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)((HoglinEntity)event.getEntity()), EmbodyEntity.class, 16.0f, 1.2, 1.2));
            }
        }
        if (event.getEntity() instanceof SpiderEntity && InfernalExpansionConfig.MobInteractions.SPIDER_ATTACK_WARPBEETLE.getBoolean()) {
            ((SpiderEntity)event.getEntity()).field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((SpiderEntity)event.getEntity()), WarpbeetleEntity.class, true, false));
        }
        if (event.getEntity() instanceof SkeletonEntity) {
            if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_PIGLIN.getBoolean()) {
                ((SkeletonEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((SkeletonEntity)event.getEntity()), PiglinEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_BRUTE.getBoolean()) {
                ((SkeletonEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((SkeletonEntity)event.getEntity()), PiglinBruteEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_EMBODY.getBoolean()) {
                ((SkeletonEntity)event.getEntity()).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((SkeletonEntity)event.getEntity()), EmbodyEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_GIANT.getBoolean()) {
                ((SkeletonEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((SkeletonEntity)event.getEntity()), BasaltGiantEntity.class, true, false));
            }
        }
        if (event.getEntity() instanceof PiglinEntity) {
            if (InfernalExpansionConfig.MobInteractions.PIGLIN_ATTACK_SKELETON.getBoolean()) {
                ((PiglinEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((PiglinEntity)event.getEntity()), SkeletonEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.PIGLIN_ATTACK_VOLINE.getBoolean()) {
                ((PiglinEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((PiglinEntity)event.getEntity()), VolineEntity.class, true, false));
            }
        }
        if (event.getEntity() instanceof PiglinBruteEntity) {
            if (InfernalExpansionConfig.MobInteractions.BRUTE_ATTACK_SKELETON.getBoolean()) {
                ((PiglinBruteEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((PiglinBruteEntity)event.getEntity()), SkeletonEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.BRUTE_ATTACK_VOLINE.getBoolean()) {
                ((PiglinBruteEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((PiglinBruteEntity)event.getEntity()), VolineEntity.class, true, false));
            }
        }
        if (event.getEntity() instanceof GhastEntity) {
            if (InfernalExpansionConfig.MobInteractions.GHAST_ATTACK_GLOWSQUITO.getBoolean()) {
                ((GhastEntity)event.getEntity()).field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((GhastEntity)event.getEntity()), GlowsquitoEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.GHAST_ATTACK_EMBODY.getBoolean()) {
                ((GhastEntity)event.getEntity()).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((GhastEntity)event.getEntity()), EmbodyEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.GHAST_ATTACK_VOLINE.getBoolean()) {
                ((GhastEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((GhastEntity)event.getEntity()), VolineEntity.class, true, false));
            }
            if (InfernalExpansionConfig.MobInteractions.GHAST_ATTACK_SKELETON.getBoolean()) {
                ((GhastEntity)event.getEntity()).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((GhastEntity)event.getEntity()), SkeletonEntity.class, true, false));
            }
        }
        if (event.getEntity() instanceof MagmaCubeEntity) {
            ((MagmaCubeEntity)event.getEntity()).field_70714_bg.func_75776_a(0, (Goal)new AvoidBlockGoal((SlimeEntity)((MagmaCubeEntity)event.getEntity()), IETags.Blocks.MAGMA_CUBE_AVOID_BLOCKS, 8));
        }
    }

    private void addEntityToSpawner(BiomeLoadingEvent event, EntityType<?> entityType, SpawnrateManager.SpawnInfo spawnInfo) {
        event.getSpawns().func_242575_a(entityType.func_220339_d(), new MobSpawnInfo.Spawners(entityType, spawnInfo.getSpawnRate(), spawnInfo.getMinCount(), spawnInfo.getMaxCount()));
        if (spawnInfo.getSpawnCostPerEntity() != null && spawnInfo.getMaxSpawnCost() != null) {
            event.getSpawns().func_242573_a(entityType, spawnInfo.getSpawnCostPerEntity().doubleValue(), spawnInfo.getMaxSpawnCost().doubleValue());
        } else if (spawnInfo.getSpawnCostPerEntity() != null || spawnInfo.getMaxSpawnCost() != null) {
            InfernalExpansion.LOGGER.error("EntityType {} has incomplete spawn cost data. When editing spawn costs, make sure to set both \"spawn_cost_per_entity\" and \"max_spawn_cost\"", (Object)entityType.toString());
        }
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() != Biome.Category.NETHER) {
            return;
        }
        MiscEvents.getSpawnrateManager().forEach((entity, value) -> {
            List<String> spawnableBiomes = Arrays.asList(InfernalExpansionConfig.MobSpawning.getByName(entity.split(":")[1]).getSpawnableBiomes().replace(" ", "").split(","));
            if (!spawnableBiomes.contains(event.getName().toString())) {
                return;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entity));
            if (entityType == null) {
                throw new ResourceLocationException("Invalid EntityType resource location " + entity);
            }
            if (value.containsKey(event.getName().toString()) && spawnableBiomes.contains(event.getName().toString())) {
                this.addEntityToSpawner(event, entityType, (SpawnrateManager.SpawnInfo)value.get(event.getName().toString()));
            } else if (value.containsKey("default") && spawnableBiomes.contains(event.getName().toString())) {
                this.addEntityToSpawner(event, entityType, (SpawnrateManager.SpawnInfo)value.get("default"));
            } else {
                InfernalExpansion.LOGGER.error("{} doesn't have a default spawn entry", entity);
            }
        });
    }
}

