/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.GlowsquitoEntity;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class BlackstoneDwarfEntity
extends CreatureEntity
implements IAngerable {
    private static final RangedInteger RANGED_INT = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int attackTimer;
    private int angerTime;
    private UUID angerTarget;

    public BlackstoneDwarfEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233820_c_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a((SoundEvent)IESoundEvents.BASALT_GIANT_DEATH.get(), 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean disableShield = false;
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        float f2 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).func_184607_cu().isShield((LivingEntity)((PlayerEntity)entityIn))) {
            this.attackFling(entityIn, f2 * 3.0f, 2.0);
            entityIn.field_70133_I = true;
            disableShield = true;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1)) {
            this.attackFling(entityIn, f2, 0.6);
        }
        if (disableShield) {
            ((PlayerEntity)entityIn).func_190777_m(true);
        }
        this.func_184185_a((SoundEvent)IESoundEvents.BASALT_GIANT_HURT.get(), 1.0f, 1.0f);
        return flag;
    }

    private void attackFling(Entity entityIn, float f2, double height) {
        ((LivingEntity)entityIn).func_233627_a_(f2, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
        entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, height, 0.0));
        this.func_174815_a((LivingEntity)this, entityIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.DWARF_ATTACK_PIGLIN.getBoolean()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractPiglinEntity.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.DWARF_ATTACK_ZOMBIE_PIGLIN.getBoolean()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombifiedPiglinEntity.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.DWARF_ATTACK_PLAYER.getBoolean()) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }
        if (InfernalExpansionConfig.MobInteractions.GLOWSQUITO_ATTACK_DWARF.getBoolean()) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, GlowsquitoEntity.class, true));
        }
    }

    protected int func_70693_a(PlayerEntity player) {
        return 2 + this.field_70170_p.field_73012_v.nextInt(2);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(RANGED_INT.func_233018_a_(this.field_70146_Z));
    }
}

