/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;

public class SpawnrateManager {
    private static final Gson GSON_INSTANCE = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final Map<String, Map<String, SpawnInfo>> SPAWNRATES = new HashMap<String, Map<String, SpawnInfo>>();
    private static final Map<String, Map<String, SpawnInfo>> configs = ImmutableMap.builder().put((Object)"basalt_giant", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(5, 1, 1, 5.2, 0.1), (Object)"minecraft:basalt_deltas", (Object)new SpawnInfo(30, 1, 1, 3.2, 0.1), (Object)"infernalexp:delta_shores", (Object)new SpawnInfo(4, 1, 1, 100.2, 0.1))).put((Object)"blackstone_dwarf", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(0, 0, 0, 0.0, 0.0))).put((Object)"blindsight", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(30, 1, 1, 0.0, 0.0), (Object)"infernalexp:glowstone_canyon", (Object)new SpawnInfo(30, 1, 1, 7.2, 0.9))).put((Object)"embody", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(90, 1, 5, 0.0, 0.0), (Object)"minecraft:soul_sand_valley", (Object)new SpawnInfo(120, 1, 3, 1.2, 0.1))).put((Object)"glowsilk_moth", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(5, 1, 1, 6.2, 0.1), (Object)"infernalexp:glowstone_canyon", (Object)new SpawnInfo(1, 1, 1, 4.2, 0.1), (Object)"minecraft:crimson_forest", (Object)new SpawnInfo(1, 1, 1, 8.2, 0.1), (Object)"minecraft:basalt_deltas", (Object)new SpawnInfo(1, 1, 1, 8.2, 0.1))).put((Object)"glowsquito", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(20, 1, 3, 0.0, 0.0), (Object)"infernalexp:glowstone_canyon", (Object)new SpawnInfo(80, 1, 10, 1.2, 0.1))).put((Object)"shroomloin", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(5, 1, 3, 7.2, 0.1), (Object)"minecraft:crimson_forest", (Object)new SpawnInfo(30, 1, 1, 16.2, 0.1))).put((Object)"voline", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(50, 1, 3, 1.2, 0.1), (Object)"minecraft:nether_wastes", (Object)new SpawnInfo(50, 1, 3, 1.2, 0.1), (Object)"minecraft:crimson_forest", (Object)new SpawnInfo(1, 1, 5, 8.2, 0.1))).put((Object)"warpbeetle", (Object)ImmutableMap.of((Object)"default", (Object)new SpawnInfo(5, 1, 1, 0.0, 0.0), (Object)"minecraft:warped_forest", (Object)new SpawnInfo(50, 1, 3, 2.6, 0.1))).build();

    public SpawnrateManager() {
        this.loadResources();
    }

    private static void createResource(String entity) {
        if (!configs.containsKey(entity)) {
            InfernalExpansion.LOGGER.error("{} doesn't exist in the configs map", (Object)entity);
        }
        Map<String, SpawnInfo> configData = configs.get(entity);
        ArrayList formattedConfigData = new ArrayList();
        configData.forEach((biome, spawnInfo) -> formattedConfigData.add(new SpawnBiomeEntry((String)biome, (SpawnInfo)spawnInfo)));
        JsonObject config = new JsonObject();
        JsonElement configInner = GSON_INSTANCE.toJsonTree(formattedConfigData);
        config.add("biomes", configInner);
        try {
            String json = GSON_INSTANCE.toJson((JsonElement)config);
            FileWriter writer = new FileWriter(FMLPaths.CONFIGDIR.get() + "/infernalexp/spawnrates/" + entity + "_spawns.json");
            writer.write(json);
            writer.close();
        }
        catch (IOException exception) {
            InfernalExpansion.LOGGER.error("There was an error with creating the file {} /infernalexp/spawnrates/{}_spawns.json Exception: {}", (Object)FMLPaths.CONFIGDIR.get(), (Object)entity, (Object)exception);
        }
    }

    public static void createResources() {
        if (!new File(FMLPaths.CONFIGDIR.get() + "/infernalexp/spawnrates/").exists()) {
            try {
                Files.createDirectories(Paths.get(FMLPaths.CONFIGDIR.get() + "/infernalexp/spawnrates", new String[0]), new FileAttribute[0]);
            }
            catch (IOException exception) {
                InfernalExpansion.LOGGER.error("There was an error with creating the directory {} /infernalexp/spawnrates Exception: {}", (Object)FMLPaths.CONFIGDIR.get(), (Object)exception);
            }
        }
        for (String entity : configs.keySet()) {
            File file = new File(FMLPaths.CONFIGDIR.get() + "/infernalexp/spawnrates/" + entity + "_spawns.json");
            if (file.exists()) continue;
            SpawnrateManager.createResource(entity);
        }
    }

    public void loadResources() {
        SpawnrateManager.createResources();
        File spawnrateDirectory = new File(FMLPaths.CONFIGDIR.get().toString() + "/infernalexp/spawnrates");
        for (String entity : configs.keySet()) {
            String resourceLocation = "infernalexp:" + entity;
            if (!ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(resourceLocation)) || !InfernalExpansionConfig.MobSpawning.contains(entity)) {
                throw new ResourceLocationException(entity.split(":")[1] + " does not exist in the registry or is not a naturally spawning mob from Infernal Expansion");
            }
            HashMap<String, SpawnInfo> entitySpawns = new HashMap<String, SpawnInfo>();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(spawnrateDirectory + "/" + entity + "_spawns.json"), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    JsonObject jsonObject = (JsonObject)JSONUtils.func_193839_a((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                    if (jsonObject != null) {
                        for (JsonElement entry : jsonObject.getAsJsonArray("biomes")) {
                            JsonObject spawnInfo = entry.getAsJsonObject().getAsJsonObject("spawn_info");
                            entitySpawns.put(entry.getAsJsonObject().get("biome").getAsString(), new SpawnInfo(spawnInfo.get("spawn_rate").getAsInt(), spawnInfo.get("min_count").getAsInt(), spawnInfo.get("max_count").getAsInt(), Optional.ofNullable(spawnInfo.get("spawn_cost_per_entity")).map(JsonElement::getAsDouble).orElse(0.0), Optional.ofNullable(spawnInfo.get("max_spawn_cost")).map(JsonElement::getAsDouble).orElse(0.0)));
                        }
                    }
                    SPAWNRATES.put(resourceLocation, entitySpawns);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException exception) {
                InfernalExpansion.LOGGER.error("Couldn't read spawn table list {}, Exception: {}", (Object)(entity + "_spawns.json"), (Object)exception);
            }
        }
    }

    public Map<String, Map<String, SpawnInfo>> getSpawnrates() {
        return SPAWNRATES;
    }

    private static class SpawnBiomeEntry {
        private final String biome;
        private final SpawnInfo spawnInfo;

        public SpawnBiomeEntry(String biome, SpawnInfo spawnInfo) {
            this.biome = biome;
            this.spawnInfo = spawnInfo;
        }
    }

    public static class SpawnInfo {
        private final int spawnRate;
        private final int minCount;
        private final int maxCount;
        private final Double spawnCostPerEntity;
        private final Double maxSpawnCost;

        public SpawnInfo(int spawnRate, int minCount, int maxCount, double spawnCostPerEntity, double maxSpawnCost) {
            this.spawnRate = spawnRate;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.spawnCostPerEntity = spawnCostPerEntity == 0.0 ? null : Double.valueOf(spawnCostPerEntity);
            this.maxSpawnCost = maxSpawnCost == 0.0 ? null : Double.valueOf(maxSpawnCost);
        }

        public int getSpawnRate() {
            return this.spawnRate;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public Double getSpawnCostPerEntity() {
            return this.spawnCostPerEntity;
        }

        public Double getMaxSpawnCost() {
            return this.maxSpawnCost;
        }
    }
}

