/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.client.DynamicLightingHandler;
import org.infernalstudios.infernalexp.client.gui.InfectionHeartOverlay;
import org.infernalstudios.infernalexp.config.gui.screens.ConfigScreen;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.items.WhipItem;

@OnlyIn(value=Dist.CLIENT)
public class InfernalExpansionClient {
    public static void init(Consumer<Runnable> enqueueWorkConsumer) {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfigScreen());
        MinecraftForge.EVENT_BUS.register((Object)new InfectionHeartOverlay());
        MinecraftForge.EVENT_BUS.addListener(event -> DynamicLightingHandler.tick(event.getEntityLiving()));
        enqueueWorkConsumer.accept(InfernalExpansionClient::threadSafeInit);
    }

    private static void threadSafeInit() {
        ItemModelsProperties.func_239418_a_((Item)((Item)IEItems.GLOWSILK_BOW.get()), (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.func_184607_cu() != itemStack ? 0.0f : (float)(itemStack.func_77988_m() - livingEntity.func_184605_cv()) / 20.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)IEItems.GLOWSILK_BOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity) -> livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == itemStack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)IEItems.BLINDSIGHT_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attack_frame"), (itemStack, clientWorld, livingEntity) -> livingEntity == null || livingEntity.func_184614_ca() != itemStack && livingEntity.func_184592_cb() != itemStack ? 0.0f : (float)((int)((float)((WhipItem)itemStack.func_77973_b()).getTicksSinceAttack(itemStack) / 3.0f)));
        ItemModelsProperties.func_239418_a_((Item)((Item)IEItems.BLINDSIGHT_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attacking"), (itemStack, clientWorld, livingEntity) -> !(livingEntity == null || !((WhipItem)itemStack.func_77973_b()).getAttacking(itemStack) && !((WhipItem)itemStack.func_77973_b()).getCharging(itemStack) || livingEntity.func_184614_ca() != itemStack && livingEntity.func_184592_cb() != itemStack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)IEItems.KINETIC_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attack_frame"), (itemStack, clientWorld, livingEntity) -> livingEntity == null || livingEntity.func_184614_ca() != itemStack && livingEntity.func_184592_cb() != itemStack ? 0.0f : (float)((int)((float)((WhipItem)itemStack.func_77973_b()).getTicksSinceAttack(itemStack) / 3.0f)));
        ItemModelsProperties.func_239418_a_((Item)((Item)IEItems.KINETIC_TONGUE_WHIP.get()), (ResourceLocation)new ResourceLocation("attacking"), (itemStack, clientWorld, livingEntity) -> !(livingEntity == null || !((WhipItem)itemStack.func_77973_b()).getAttacking(itemStack) && !((WhipItem)itemStack.func_77973_b()).getCharging(itemStack) || livingEntity.func_184614_ca() != itemStack && livingEntity.func_184592_cb() != itemStack) ? 1.0f : 0.0f);
        InfernalExpansionClient.loadInfernalResources();
    }

    public static void loadInfernalResources() {
        File dir = new File(".", "resourcepacks");
        File target = new File(dir, "Infernal Resources.zip");
        if (!target.exists()) {
            try {
                dir.mkdirs();
                InputStream in = InfernalExpansion.class.getResourceAsStream("/assets/infernalexp/infernal_resources.zip");
                FileOutputStream out = new FileOutputStream(target);
                byte[] buf = new byte[16384];
                int len = 0;
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

