/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.brewing;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.infernalstudios.infernalexp.mixin.common.IngredientAccessor;

public class BrewingHelper {
    private static final MethodHandle CREATE_NEW_MIX_PREDICATE;
    private static final MethodHandle GET_POTION_TYPE_CONVERSIONS_LIST;

    private static void addBrewingRecipe(Potion input, Supplier<Ingredient> reagent, Potion output) {
        try {
            Object mixPredicate = CREATE_NEW_MIX_PREDICATE.invokeExact((ForgeRegistryEntry)input, reagent.get(), (ForgeRegistryEntry)output);
            List typeConversions = GET_POTION_TYPE_CONVERSIONS_LIST.invokeExact();
            typeConversions.add(mixPredicate);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void registerBrewingRecipe(Item ingredient, Potion normalPotion, Potion longPotion, Potion strongPotion) {
        Supplier<Ingredient> reagent = () -> BrewingHelper.createIngredient(ingredient);
        BrewingHelper.addBrewingRecipe(Potions.field_185230_b, reagent, Potions.field_185231_c);
        BrewingHelper.addBrewingRecipe(Potions.field_185233_e, reagent, normalPotion);
        BrewingHelper.addBrewingRecipe(normalPotion, () -> BrewingHelper.createIngredient(Items.field_151137_ax), longPotion);
        BrewingHelper.addBrewingRecipe(normalPotion, () -> BrewingHelper.createIngredient(Items.field_151114_aO), strongPotion);
    }

    private static Ingredient createIngredient(Item ingredient) {
        return IngredientAccessor.createIngredient(Stream.of(new Ingredient.SingleItemList(new ItemStack((IItemProvider)ingredient))));
    }

    static {
        try {
            Class<?> mixPredicateClass = Class.forName("net.minecraft.potion.PotionBrewing$MixPredicate");
            MethodType constructorType = MethodType.methodType(Void.TYPE, ForgeRegistryEntry.class, Ingredient.class, ForgeRegistryEntry.class);
            Constructor<?> constructor = mixPredicateClass.getConstructor(constructorType.parameterArray());
            constructor.setAccessible(true);
            CREATE_NEW_MIX_PREDICATE = MethodHandles.lookup().unreflectConstructor(constructor).asType(constructorType.changeReturnType(Object.class));
            Field typeConversions = ObfuscationReflectionHelper.findField(PotionBrewing.class, (String)"field_185213_a");
            GET_POTION_TYPE_CONVERSIONS_LIST = MethodHandles.lookup().unreflectGetter(typeConversions).asType(MethodType.methodType(List.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException exception) {
            throw new RuntimeException(exception);
        }
    }
}

