/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import javax.annotation.CheckForNull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IETags;

public class PlantedQuartzBlock
extends HorizontalBushBlock {
    protected static final VoxelShape FLOOR_SHAPE = PlantedQuartzBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape CEILING_SHAPE = PlantedQuartzBlock.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape WALL_SHAPE_NORTH = PlantedQuartzBlock.func_208617_a((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WALL_SHAPE_SOUTH = PlantedQuartzBlock.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0);
    protected static final VoxelShape WALL_SHAPE_EAST = PlantedQuartzBlock.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WALL_SHAPE_WEST = PlantedQuartzBlock.func_208617_a((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);

    public PlantedQuartzBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    @Override
    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c().func_203417_a(IETags.Blocks.PLANTED_QUARTZ_BASE_BLOCKS);
    }

    @CheckForNull
    public BlockState getPlaceableState(World world, BlockPos pos, Direction placeSide) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() && world.func_180495_p(pos).func_177230_c() != IEBlocks.PLANTED_QUARTZ.get()) {
            Direction attachdirection;
            if (this.isValidGround(world.func_180495_p(pos.func_177972_a(placeSide.func_176734_d())), (IBlockReader)world, pos)) {
                attachdirection = placeSide.func_176734_d();
            } else if (this.isValidGround(world.func_180495_p(pos.func_177972_a(placeSide)), (IBlockReader)world, pos)) {
                attachdirection = placeSide;
            } else {
                return null;
            }
            AttachFace attachface = attachdirection == Direction.UP ? AttachFace.CEILING : (attachdirection == Direction.DOWN ? AttachFace.FLOOR : AttachFace.WALL);
            if (attachface == AttachFace.WALL) {
                return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)attachface)).func_206870_a((Property)field_185512_D, (Comparable)attachdirection.func_176734_d());
            }
            return (BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)attachface);
        }
        return null;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.canAttach(worldIn, pos, PlantedQuartzBlock.func_196365_i((BlockState)state).func_176734_d());
    }

    public boolean canAttach(IWorldReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return this.isValidGround(reader.func_180495_p(blockpos), (IBlockReader)reader, blockpos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case NORTH: {
                        return WALL_SHAPE_NORTH;
                    }
                    case SOUTH: {
                        return WALL_SHAPE_SOUTH;
                    }
                    case EAST: {
                        return WALL_SHAPE_EAST;
                    }
                }
                return WALL_SHAPE_WEST;
            }
            case FLOOR: {
                return FLOOR_SHAPE;
            }
        }
        return CEILING_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builderIn) {
        builderIn.func_206894_a(new Property[]{field_185512_D, field_196366_M});
    }

    public Item func_199767_j() {
        return Items.field_151128_bU;
    }
}

