/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FireType {
    private static final Map<ResourceLocation, FireType> FIRE_TYPES = new HashMap<ResourceLocation, FireType>();
    private final ResourceLocation name;
    private final ResourceLocation block;
    private final ResourceLocation sprite0;
    private final ResourceLocation sprite1;

    private FireType(ResourceLocation name, ResourceLocation block, ResourceLocation sprite0, ResourceLocation sprite1) {
        this.name = name;
        this.block = block;
        this.sprite0 = sprite0;
        this.sprite1 = sprite1;
        FIRE_TYPES.put(name, this);
    }

    public static FireType register(ResourceLocation name) {
        return FireType.register(name, name, "block/" + name.func_110623_a());
    }

    public static FireType register(ResourceLocation name, ResourceLocation block) {
        return FireType.register(name, block, "block/" + name.func_110623_a());
    }

    public static FireType register(ResourceLocation name, ResourceLocation block, String spriteLocation) {
        return FireType.register(name, block, spriteLocation + "_0", spriteLocation + "_1");
    }

    public static FireType register(ResourceLocation name, ResourceLocation block, String spriteLocation0, String spriteLocation1) {
        if (FIRE_TYPES.containsKey(name)) {
            throw new IllegalStateException(name.toString() + " already exists in the FireType registry.");
        }
        return new FireType(name, block, new ResourceLocation(name.func_110624_b(), spriteLocation0), new ResourceLocation(name.func_110624_b(), spriteLocation1));
    }

    public static FireType getOrDefault(ResourceLocation name, FireType defaultType) {
        return FIRE_TYPES.getOrDefault(name, defaultType);
    }

    public static Set<FireType> getFireTypes() {
        return new HashSet<FireType>(FIRE_TYPES.values());
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceLocation getBlock() {
        return this.block;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderMaterial getSprite0() {
        return RenderMaterialCache.getOrCreate(this.sprite0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderMaterial getSprite1() {
        return RenderMaterialCache.getOrCreate(this.sprite1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class RenderMaterialCache {
        private static final Map<ResourceLocation, RenderMaterial> RENDER_MATERIALS = new HashMap<ResourceLocation, RenderMaterial>();

        private RenderMaterialCache() {
        }

        private static RenderMaterial getOrCreate(ResourceLocation resourceLocation) {
            if (!RENDER_MATERIALS.containsKey(resourceLocation)) {
                RENDER_MATERIALS.put(resourceLocation, new RenderMaterial(AtlasTexture.field_110575_b, resourceLocation));
            }
            return RENDER_MATERIALS.get(resourceLocation);
        }
    }
}

