/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="illagersweararmor", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IWAConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static float Wave1Chances;
    public static float Wave2Chances;
    public static float Wave3Chances;
    public static float Wave4Chances;
    public static float Wave5Chances;
    public static float Wave6Chances;
    public static float Wave7Chances;
    public static float Wave8Chances;
    public static Boolean PillagerRenderArmor;
    public static Boolean EvokerRenderArmor;
    public static Boolean IllusionerRenderArmor;
    public static Boolean VindicatorRenderArmor;
    public static Boolean EnchanterRenderArmor;
    public static Boolean HunterRenderArmor;
    public static Boolean IllagerArmor;
    public static Boolean IllagerCrossArms;
    public static float EnchanterHelmetHeight;
    public static List<String> ArmorBlackList;

    public static void bakeCommonConfig() {
        Wave1Chances = ((Double)IWAConfig.COMMON.Wave1.get()).floatValue();
        Wave2Chances = ((Double)IWAConfig.COMMON.Wave2.get()).floatValue();
        Wave3Chances = ((Double)IWAConfig.COMMON.Wave3.get()).floatValue();
        Wave4Chances = ((Double)IWAConfig.COMMON.Wave4.get()).floatValue();
        Wave5Chances = ((Double)IWAConfig.COMMON.Wave5.get()).floatValue();
        Wave6Chances = ((Double)IWAConfig.COMMON.Wave6.get()).floatValue();
        Wave7Chances = ((Double)IWAConfig.COMMON.Wave7.get()).floatValue();
        Wave8Chances = ((Double)IWAConfig.COMMON.Wave8.get()).floatValue();
        ArmorBlackList = (List)IWAConfig.COMMON.ArmorBlackList.get();
        IllagerArmor = (Boolean)IWAConfig.COMMON.IllagerArmor.get();
    }

    public static void bakeClientConfig() {
        PillagerRenderArmor = (Boolean)IWAConfig.CLIENT.PillagerArmor.get();
        EvokerRenderArmor = (Boolean)IWAConfig.CLIENT.EvokerArmor.get();
        IllusionerRenderArmor = (Boolean)IWAConfig.CLIENT.IllusionerArmor.get();
        VindicatorRenderArmor = (Boolean)IWAConfig.CLIENT.VindicatorArmor.get();
        EnchanterRenderArmor = (Boolean)IWAConfig.CLIENT.EnchanterArmor.get();
        IllagerCrossArms = (Boolean)IWAConfig.CLIENT.IllagerCrossArms.get();
        HunterRenderArmor = (Boolean)IWAConfig.CLIENT.HunterArmor.get();
        EnchanterHelmetHeight = ((Double)IWAConfig.CLIENT.EnchanterHelmetHeight.get()).floatValue();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            IWAConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            IWAConfig.bakeClientConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue PillagerArmor;
        public final ForgeConfigSpec.BooleanValue EvokerArmor;
        public final ForgeConfigSpec.BooleanValue IllusionerArmor;
        public final ForgeConfigSpec.BooleanValue VindicatorArmor;
        public final ForgeConfigSpec.BooleanValue EnchanterArmor;
        public final ForgeConfigSpec.BooleanValue HunterArmor;
        public final ForgeConfigSpec.BooleanValue IllagerCrossArms;
        public final ForgeConfigSpec.DoubleValue EnchanterHelmetHeight;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.PillagerArmor = builder.translation("illagersweararmor.config.pillagerarmor").define("Have Pillagers render armor?", true);
            this.EvokerArmor = builder.translation("illagersweararmor.config.evokerarmor").define("Have Evokers render armor?", true);
            this.IllusionerArmor = builder.translation("illagersweararmor.config.illusionarmor").define("Have Illusioners render armor?", true);
            this.VindicatorArmor = builder.translation("illagersweararmor.config.vindiarmor").define("Have Vindicators render armor?", true);
            this.EnchanterArmor = builder.translation("illagersweararmor.config.enchantarmor").define("Have Enchanters from Enchant with Mob render armor?", true);
            this.HunterArmor = builder.translation("illagersweararmor.config.hunterarmor").define("Have the Hunters from Hunter Illagers render armor?", true);
            this.EnchanterHelmetHeight = builder.translation("illagersweararmor.config.height").defineInRange("Height of the Enchanters helmet", -15.0, -500.0, 100.0);
            this.IllagerCrossArms = builder.translation("illagersweararmor.config.illagerCrossArms").define("Have Illagers cross their arms when neutral?", true);
        }
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.DoubleValue Wave1;
        public final ForgeConfigSpec.DoubleValue Wave2;
        public final ForgeConfigSpec.DoubleValue Wave3;
        public final ForgeConfigSpec.DoubleValue Wave4;
        public final ForgeConfigSpec.DoubleValue Wave5;
        public final ForgeConfigSpec.DoubleValue Wave6;
        public final ForgeConfigSpec.DoubleValue Wave7;
        public final ForgeConfigSpec.DoubleValue Wave8;
        public final ForgeConfigSpec.BooleanValue IllagerArmor;
        public final ForgeConfigSpec.ConfigValue<List<String>> ArmorBlackList;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.Wave1 = builder.translation("illagersweararmor.config.wave1").defineInRange("Wave 1 Armor Chances", (double)0.3f, (double)1.0E-4f, 100.0);
            this.Wave2 = builder.translation("illagersweararmor.config.wave2").defineInRange("Wave 2 Armor Chances", (double)0.32f, (double)1.0E-4f, 100.0);
            this.Wave3 = builder.translation("illagersweararmor.config.wave3").defineInRange("Wave 3 Armor Chances", (double)0.34f, (double)1.0E-4f, 100.0);
            this.Wave4 = builder.translation("illagersweararmor.config.wave4").defineInRange("Wave 4 Armor Chances", (double)0.36f, (double)1.0E-4f, 100.0);
            this.Wave5 = builder.translation("illagersweararmor.config.wave5").defineInRange("Wave 5 Armor Chances", (double)0.38f, (double)1.0E-4f, 100.0);
            this.Wave6 = builder.translation("illagersweararmor.config.wave6").defineInRange("Wave 6 Armor Chances", (double)0.4f, (double)1.0E-4f, 100.0);
            this.Wave7 = builder.translation("illagersweararmor.config.wave7").defineInRange("Wave 7 Armor Chances", (double)0.42f, (double)1.0E-4f, 100.0);
            this.Wave8 = builder.translation("illagersweararmor.config.wave7").defineInRange("Wave 8 Armor Chances", (double)0.48f, (double)1.0E-4f, 100.0);
            this.ArmorBlackList = builder.translation("illagersweararmor.config.blacklist").comment("This will make sure any entity id in this list wont spawn with armor.").define("Illager Armor BlackList", new ArrayList());
            this.IllagerArmor = builder.translation("illagersweararmor.config.illagerArmor").define("Have Illagers spawn with armor at all?", true);
        }
    }
}

