/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public final class QuestKey
implements Comparable<QuestKey> {
    public final UUID uuid;
    public final long id;

    public static QuestKey of(UUID uuid, long reward) {
        return new QuestKey(uuid, reward);
    }

    public static QuestKey of(PacketBuffer buf) {
        return QuestKey.of(buf.func_179253_g(), buf.readLong());
    }

    public static QuestKey of(String string) {
        return QuestKey.of(UUIDTypeAdapter.fromString((String)string.substring(0, 32)), QuestObjectBase.parseCodeString(string.substring(33)));
    }

    private QuestKey(UUID i, long r) {
        this.uuid = i;
        this.id = r;
    }

    public String toString() {
        return UUIDTypeAdapter.fromUUID((UUID)this.uuid) + ":" + QuestObjectBase.getCodeString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestKey claimKey = (QuestKey)o;
        return this.id == claimKey.id && Objects.equals(this.uuid, claimKey.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.id);
    }

    @Override
    public int compareTo(@NotNull QuestKey key) {
        int i = this.uuid.compareTo(key.uuid);
        return i == 0 ? Long.compareUnsigned(this.id, key.id) : i;
    }

    public void write(PacketBuffer buf) {
        buf.func_179252_a(this.uuid);
        buf.writeLong(this.id);
    }
}

