/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EnergyTask
extends Task
implements ISingleLongValueTask {
    public long value = 1000L;
    public long maxInput = 0L;

    public EnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
        if (this.maxInput > 0L) {
            nbt.func_74772_a("max_input", this.maxInput);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
        if (this.value < 1L) {
            this.value = 1L;
        }
        this.maxInput = nbt.func_74763_f("max_input");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_179254_b(this.value);
        buffer.func_179254_b(this.maxInput);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.value = buffer.func_179260_f();
        this.maxInput = buffer.func_179260_f();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new StringTextComponent(StringUtils.formatDouble((double)this.value, (boolean)true));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1000L, 1L, Long.MAX_VALUE);
        config.addLong("max_input", this.maxInput, v -> {
            this.maxInput = v;
        }, 0L, 0L, Integer.MAX_VALUE).setNameKey("ftbquests.task.max_input");
    }
}

