/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPReward
extends Reward {
    public int xp;

    public XPReward(Quest quest, int x) {
        super(quest);
        this.xp = x;
    }

    public XPReward(Quest quest) {
        this(quest, 100);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("xp", this.xp);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.xp = nbt.func_74762_e("xp");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_150787_b(this.xp);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.xp = buffer.func_150792_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("xp", this.xp, v -> {
            this.xp = v;
        }, 100, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp");
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        player.func_195068_e(this.xp);
        if (notify) {
            new DisplayRewardToastMessage(this.id, (ITextComponent)new TranslationTextComponent("ftbquests.reward.ftbquests.xp").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent("+" + this.xp).func_240699_a_(TextFormatting.GREEN)), (Icon)Icon.EMPTY).sendTo(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new TranslationTextComponent("ftbquests.reward.ftbquests.xp").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent("+" + this.xp).func_240699_a_(TextFormatting.GREEN));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return "+" + this.xp;
    }
}

