/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.RewardNotificationsScreen;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LootReward
extends RandomReward {
    public LootReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.LOOT;
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        RewardTable table = this.getTable();
        if (table == null) {
            return;
        }
        for (WeightedReward reward : table.rewards) {
            if (reward.weight != 0) continue;
            reward.reward.claim(player, notify);
        }
        int totalWeight = table.getTotalWeight(true);
        if (totalWeight <= 0) {
            return;
        }
        block1: for (int i = 0; i < table.lootSize; ++i) {
            int currentWeight = table.emptyWeight;
            int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
            if (currentWeight >= number) continue;
            for (WeightedReward reward : table.rewards) {
                if ((currentWeight += reward.weight) < number) continue;
                reward.reward.claim(player, notify);
                continue block1;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list) {
        if (this.getTable() != null) {
            this.getTable().addMouseOverText(list, true, true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            new RewardNotificationsScreen().openGui();
        }
        super.onButtonClicked(button, canClick);
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return true;
    }

    @Override
    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable ServerPlayerEntity player) {
        return false;
    }

    @Override
    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable ServerPlayerEntity player) {
    }
}

