/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementReward
extends Reward {
    public ResourceLocation advancement = new ResourceLocation("minecraft:story/root");
    public String criterion = "";

    public AdvancementReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.ADVANCEMENT;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("advancement", this.advancement.toString());
        nbt.func_74778_a("criterion", this.criterion);
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.advancement = new ResourceLocation(nbt.func_74779_i("advancement"));
        this.criterion = nbt.func_74779_i("criterion");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_192572_a(this.advancement);
        buffer.func_211400_a(this.criterion, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.advancement = buffer.func_192575_l();
        this.criterion = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        if (KnownServerRegistries.client != null && !KnownServerRegistries.client.advancements.isEmpty()) {
            config.addEnum("advancement", (Object)this.advancement, v -> {
                this.advancement = v;
            }, NameMap.of((Object)((ResourceLocation)KnownServerRegistries.client.advancements.keySet().iterator().next()), (Object[])KnownServerRegistries.client.advancements.keySet().toArray(new ResourceLocation[0])).icon(resourceLocation -> ItemIcon.getItemIcon((ItemStack)((KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get((Object)resourceLocation)).icon)).name(resourceLocation -> ((KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get((Object)resourceLocation)).name).create()).setNameKey("ftbquests.reward.ftbquests.advancement");
        } else {
            config.addString("advancement", this.advancement.toString(), v -> {
                this.advancement = new ResourceLocation(v);
            }, "minecraft:story/root").setNameKey("ftbquests.reward.ftbquests.advancement");
        }
        config.addString("criterion", this.criterion, v -> {
            this.criterion = v;
        }, "");
    }

    @Override
    public void claim(ServerPlayerEntity player, boolean notify) {
        Advancement a = player.field_71133_b.func_191949_aK().func_192778_a(this.advancement);
        if (a != null) {
            if (this.criterion.isEmpty()) {
                for (String s : a.func_192073_f().keySet()) {
                    player.func_192039_O().func_192750_a(a, s);
                }
            } else {
                player.func_192039_O().func_192750_a(a, this.criterion);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAltTitle() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && info.name != StringTextComponent.field_240750_d_) {
            return new TranslationTextComponent("ftbquests.reward.ftbquests.advancement").func_240702_b_(": ").func_230529_a_((ITextComponent)info.name.func_230532_e_().func_240699_a_(TextFormatting.YELLOW));
        }
        return super.getAltTitle();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        KnownServerRegistries.AdvancementInfo info;
        KnownServerRegistries.AdvancementInfo advancementInfo = info = KnownServerRegistries.client == null ? null : (KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get(this.advancement);
        if (info != null && !info.icon.func_190926_b()) {
            return ItemIcon.getItemIcon((ItemStack)info.icon);
        }
        return super.getAltIcon();
    }
}

