/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class QuestButton
extends Button {
    public QuestScreen questScreen;
    public Quest quest;
    public QuestButton[] dependencies = null;

    public QuestButton(Panel panel, Quest q) {
        super(panel, q.getTitle(), q.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.setSize(20, 20);
        this.quest = q;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.questScreen.movingObjects || this.questScreen.viewQuestPanel.isMouseOver() || this.questScreen.chapterPanel.isMouseOver()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        if (this.questScreen.questPanel.mouseOverQuest != null && this.questScreen.questPanel.mouseOverQuest != this) {
            this.isMouseOver = false;
        }
        if (this.isMouseOver) {
            QuestShape shape = QuestShape.get(this.quest.getShape());
            int ax = this.getX();
            int ay = this.getY();
            double relX = (double)(mouseX - ax) / (double)this.width;
            double relY = (double)(mouseY - ay) / (double)this.height;
            PixelBuffer pixelBuffer = shape.getShapePixels();
            int rx = (int)(relX * (double)pixelBuffer.getWidth());
            int ry = (int)(relY * (double)pixelBuffer.getHeight());
            if (rx < 0 || ry < 0 || rx >= pixelBuffer.getWidth() || ry >= pixelBuffer.getHeight()) {
                this.isMouseOver = false;
            } else {
                int a = pixelBuffer.getRGB(rx, ry) >> 24 & 0xFF;
                if (a < 5) {
                    this.isMouseOver = false;
                }
            }
        }
        if (this.isMouseOver && this.questScreen.questPanel.mouseOverQuest == null) {
            this.questScreen.questPanel.mouseOverQuest = this;
        }
    }

    public QuestButton[] getDependencies() {
        if (this.dependencies == null) {
            ArrayList<QuestButton> list = new ArrayList<QuestButton>();
            for (QuestObject dependency : this.quest.dependencies) {
                if (dependency.invalid || !(dependency instanceof Quest)) continue;
                for (Widget widget : this.questScreen.questPanel.widgets) {
                    if (!(widget instanceof QuestButton) || dependency != ((QuestButton)widget).quest) continue;
                    list.add((QuestButton)widget);
                }
            }
            this.dependencies = list.toArray(new QuestButton[0]);
        }
        return this.dependencies;
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        if (this.questScreen.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            if (!this.questScreen.selectedObjects.isEmpty()) {
                if (!this.questScreen.selectedObjects.contains(this.quest)) {
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.add_dependencies"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                        for (Movable q : this.questScreen.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency(this.quest, (Quest)q, true);
                        }
                    }));
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.remove_dependencies"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                        for (Movable q : this.questScreen.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency(this.quest, (Quest)q, false);
                        }
                    }));
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.add_dependencies_self"), (Icon)ThemeProperties.ADD_ICON.get(), () -> {
                        for (Movable q : this.questScreen.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency((Quest)q, this.quest, true);
                        }
                    }));
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.remove_dependencies_self"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                        for (Movable q : this.questScreen.selectedObjects) {
                            if (!(q instanceof Quest)) continue;
                            this.editDependency((Quest)q, this.quest, false);
                        }
                    }));
                } else {
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("ftbquests.gui.add_reward_all"), (Icon)ThemeProperties.ADD_ICON.get(this.quest), () -> {
                        ArrayList<ContextMenuItem> contextMenu2 = new ArrayList<ContextMenuItem>();
                        for (RewardType type : RewardTypes.TYPES.values()) {
                            contextMenu2.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                                this.playClickSound();
                                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, reward -> {
                                    for (Movable movable : this.questScreen.selectedObjects) {
                                        if (!(movable instanceof Quest)) continue;
                                        Reward r = type.provider.create((Quest)movable);
                                        CompoundNBT nbt1 = new CompoundNBT();
                                        reward.writeData(nbt1);
                                        r.readData(nbt1);
                                        CompoundNBT extra = new CompoundNBT();
                                        extra.func_74778_a("type", type.getTypeForNBT());
                                        new CreateObjectMessage(r, extra).sendToServer();
                                    }
                                });
                            }));
                        }
                        this.getGui().openContextMenu(contextMenu2);
                    }));
                    contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(this.quest), () -> {
                        this.questScreen.selectedObjects.forEach(q -> {
                            if (q instanceof Quest) {
                                ClientQuestFile.INSTANCE.deleteObject(((Quest)q).id);
                            } else if (q instanceof ChapterImage) {
                                ((ChapterImage)q).chapter.images.remove(q);
                                new EditObjectMessage(((ChapterImage)q).chapter).sendToServer();
                            }
                        });
                        this.questScreen.selectedObjects.clear();
                    }).setYesNo((ITextComponent)new TranslationTextComponent("delete_item", new Object[]{new TranslationTextComponent("ftbquests.quests") + " [" + this.questScreen.selectedObjects.size() + "]"})));
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent("Ctrl+A to select all quests").func_240699_a_(TextFormatting.GRAY), Icons.INFO, null));
                contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent("Ctrl+D to deselect all quests").func_240699_a_(TextFormatting.GRAY), Icons.INFO, null));
                contextMenu.add(new ContextMenuItem((ITextComponent)new StringTextComponent("Ctrl+Arrow Key to move selected quests").func_240699_a_(TextFormatting.GRAY), Icons.INFO, null));
            } else {
                contextMenu.add(new ContextMenuItem((ITextComponent)new TranslationTextComponent("gui.move"), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.quest), () -> {
                    this.questScreen.movingObjects = true;
                    this.questScreen.selectedObjects.clear();
                    this.questScreen.toggleSelected(this.quest);
                }){

                    public void addMouseOverText(TooltipList list) {
                        list.add((ITextComponent)new TranslationTextComponent("ftbquests.gui.move_tooltip").func_240699_a_(TextFormatting.DARK_GRAY));
                    }
                });
                contextMenu.add(ContextMenuItem.SEPARATOR);
                this.questScreen.addObjectMenuItems(contextMenu, (Runnable)this.getGui(), this.quest);
            }
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (QuestButton.isCtrlKeyDown() && this.questScreen.file.canEdit()) {
                if (this.questScreen.isViewingQuest()) {
                    this.questScreen.closeQuest();
                }
                this.questScreen.toggleSelected(this.quest);
            } else if (!this.quest.guidePage.isEmpty() && this.quest.tasks.isEmpty() && this.quest.rewards.isEmpty() && this.quest.getDescription().length == 0) {
                this.handleClick("guide", this.quest.guidePage);
            } else {
                this.questScreen.open(this.quest, false);
            }
        } else if (this.questScreen.file.canEdit() && button.isMiddle()) {
            if (!this.questScreen.selectedObjects.contains(this.quest)) {
                this.questScreen.toggleSelected(this.quest);
            }
            this.questScreen.movingObjects = true;
        } else if (button.isRight()) {
            this.questScreen.movingObjects = false;
            if (this.questScreen.getViewedQuest() != this.quest) {
                this.questScreen.viewQuestPanel.hidePanel = true;
                this.questScreen.viewQuest(this.quest);
            } else {
                this.questScreen.closeQuest();
            }
        }
    }

    private void editDependency(Quest quest, QuestObject object, boolean add) {
        ArrayList<QuestObject> prevDeps = new ArrayList<QuestObject>(quest.dependencies);
        if (add != quest.hasDependency(object)) {
            if (add) {
                quest.dependencies.add(object);
            } else {
                quest.dependencies.remove(object);
            }
        }
        quest.removeInvalidDependencies();
        if (quest.verifyDependencies(false)) {
            new EditObjectMessage(quest).sendToServer();
            this.questScreen.questPanel.refreshWidgets();
        } else {
            quest.dependencies.clear();
            quest.dependencies.addAll(prevDeps);
            QuestScreen.displayError((ITextComponent)new TranslationTextComponent("ftbquests.gui.looping_dependencies"));
        }
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return this.quest.tasks.size() == 1 ? this.quest.tasks.get(0).getIngredient() : null;
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.quest);
        ITextComponent title = this.getTitle();
        if (this.questScreen.file.self != null && this.questScreen.file.self.isStarted(this.quest) && !this.questScreen.file.self.isCompleted(this.quest)) {
            title = title.func_230532_e_().func_230529_a_((ITextComponent)new StringTextComponent(" " + this.questScreen.file.self.getRelativeProgress(this.quest) + "%").func_240699_a_(TextFormatting.DARK_GRAY));
        }
        list.add(title);
        ITextComponent description = this.quest.getSubtitle();
        if (description != StringTextComponent.field_240750_d_) {
            list.add((ITextComponent)new StringTextComponent("").func_230529_a_(description).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.quest.optional) {
            list.add((ITextComponent)new StringTextComponent("[").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("ftbquests.quest.optional")).func_240702_b_("]"));
        }
    }

    public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        float s;
        boolean canStart;
        Color4I outlineColor = Color4I.WHITE.withAlpha(150);
        Color4I qicon = Icon.EMPTY;
        boolean isCompleted = this.questScreen.file.self.isCompleted(this.quest);
        boolean isStarted = isCompleted || this.questScreen.file.self.isStarted(this.quest);
        boolean bl = canStart = isCompleted || isStarted || this.questScreen.file.self.canStartTasks(this.quest);
        if (canStart) {
            if (isCompleted) {
                qicon = this.questScreen.file.self.hasUnclaimedRewards(Minecraft.func_71410_x().field_71439_g.func_110124_au(), this.quest) ? (Icon)ThemeProperties.ALERT_ICON.get(this.quest) : (this.questScreen.file.self.isQuestPinned(this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.CHECK_ICON.get(this.quest));
                outlineColor = (Color4I)ThemeProperties.QUEST_COMPLETED_COLOR.get(this.quest);
            } else if (isStarted) {
                outlineColor = (Color4I)ThemeProperties.QUEST_STARTED_COLOR.get(this.quest);
            }
        } else {
            outlineColor = Color4I.GRAY;
        }
        if (qicon == Icon.EMPTY && this.questScreen.file.self.isQuestPinned(this.quest.id)) {
            qicon = (Icon)ThemeProperties.PIN_ICON_ON.get();
        }
        QuestShape shape = QuestShape.get(this.quest.getShape());
        shape.shape.withColor(Color4I.DARK_GRAY).draw(matrixStack, x, y, w, h);
        shape.background.withColor(Color4I.WHITE.withAlpha(150)).draw(matrixStack, x, y, w, h);
        shape.outline.withColor(outlineColor).draw(matrixStack, x, y, w, h);
        if (!this.icon.isEmpty()) {
            s = (float)w * 2.0f / 3.0f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + (double)((float)w - s) / 2.0, (double)y + (double)((float)h - s) / 2.0, 0.0);
            matrixStack.func_227862_a_(s, s, 1.0f);
            this.icon.draw(matrixStack, 0, 0, 1, 1);
            matrixStack.func_227865_b_();
        }
        GuiHelper.setupDrawing();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        if (this.quest == this.questScreen.viewQuestPanel.quest || this.questScreen.selectedObjects.contains(this.quest)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            Color4I col = Color4I.WHITE.withAlpha((int)(190.0 + Math.sin((double)System.currentTimeMillis() * 0.003) * 50.0));
            shape.outline.withColor(col).draw(matrixStack, x, y, w, h);
            shape.background.withColor(col).draw(matrixStack, x, y, w, h);
            matrixStack.func_227865_b_();
        }
        if (!canStart) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            shape.shape.withColor(Color4I.BLACK.withAlpha(100)).draw(matrixStack, x, y, w, h);
            matrixStack.func_227865_b_();
        }
        if (this.isMouseOver()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 200.0);
            shape.shape.withColor(Color4I.WHITE.withAlpha(100)).draw(matrixStack, x, y, w, h);
            matrixStack.func_227865_b_();
        }
        if (!qicon.isEmpty()) {
            s = (float)w / 8.0f * 3.0f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)(x + w) - s), (double)y, 200.0);
            matrixStack.func_227862_a_(s, s, 1.0f);
            qicon.draw(matrixStack, 0, 0, 1, 1);
            matrixStack.func_227865_b_();
        }
    }
}

