/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.custom;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationLayer;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationLayerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash.TitleScreenSplashElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash.TitleScreenSplashItem;
import de.keksuccino.fancymenu.mixin.client.IMixinMainMenuScreen;
import de.keksuccino.fancymenu.mixin.client.IMixinScreen;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WinGameScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.BrandingControl;

public class MainMenuHandler
extends MenuHandlerBase {
    private final RenderSkybox panorama = new RenderSkybox(new RenderSkyboxCube(new ResourceLocation("textures/gui/title/background/panorama")));
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURES = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation MINECRAFT_TITLE_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private static final Random RANDOM = new Random();
    protected boolean showLogo = true;
    protected boolean showBranding = true;
    protected boolean showForgeNotificationCopyright = true;
    protected boolean showForgeNotificationTop = true;
    protected boolean showRealmsNotification = true;
    protected TitleScreenSplashItem splashItem = null;

    public MainMenuHandler() {
        super(MainMenuScreen.class.getName());
    }

    @Override
    public void onMenuReloaded(MenuReloadedEvent e) {
        super.onMenuReloaded(e);
        TitleScreenSplashItem.cachedSplashText = null;
    }

    @Override
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui()) && e.getGui() instanceof MainMenuScreen) {
            MainMenuHandler.setShowFadeInAnimation(false, (MainMenuScreen)e.getGui());
        }
        super.onInitPre(e);
    }

    @Override
    public void onButtonsCached(ButtonCachedEvent e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            TitleScreenSplashElement element;
            this.setWidthCopyrightRest(Integer.MAX_VALUE);
            this.showLogo = true;
            this.showBranding = true;
            this.showForgeNotificationCopyright = true;
            this.showForgeNotificationTop = true;
            this.showRealmsNotification = true;
            DeepCustomizationLayer layer = DeepCustomizationLayerRegistry.getLayerByMenuIdentifier(this.getMenuIdentifier());
            if (layer != null && (element = (TitleScreenSplashElement)layer.getElementByIdentifier("title_screen_splash")) != null) {
                this.splashItem = (TitleScreenSplashItem)element.constructDefaultItemInstance();
            }
            super.onButtonsCached(e);
        }
    }

    @Override
    protected void applyLayout(PropertiesSection sec, String renderOrder, ButtonCachedEvent e) {
        DeepCustomizationItem i;
        String elementId;
        DeepCustomizationElement element;
        String action;
        super.applyLayout(sec, renderOrder, e);
        DeepCustomizationLayer layer = DeepCustomizationLayerRegistry.getLayerByMenuIdentifier(this.getMenuIdentifier());
        if (layer != null && (action = sec.getEntryValue("action")) != null && action.startsWith("deep_customization_element:") && (element = layer.getElementByIdentifier(elementId = action.split("[:]", 2)[1])) != null && (i = element.constructCustomizedItemInstance(sec)) != null) {
            if (elementId.equals("title_screen_branding")) {
                boolean bl = this.showBranding = !i.hidden;
            }
            if (elementId.equals("title_screen_logo")) {
                boolean bl = this.showLogo = !i.hidden;
            }
            if (elementId.equals("title_screen_splash")) {
                this.splashItem = (TitleScreenSplashItem)i;
            }
            if (elementId.equals("title_screen_realms_notification")) {
                boolean bl = this.showRealmsNotification = !i.hidden;
            }
            if (elementId.equals("title_screen_forge_copyright")) {
                boolean bl = this.showForgeNotificationCopyright = !i.hidden;
            }
            if (elementId.equals("title_screen_forge_top")) {
                this.showForgeNotificationTop = !i.hidden;
            }
        }
    }

    @SubscribeEvent
    public void onRender(GuiScreenEvent.DrawScreenEvent.Pre e) {
        if (this.shouldCustomize(e.getGui()) && MenuCustomization.isMenuCustomizable(e.getGui())) {
            e.setCanceled(true);
            e.getGui().func_230446_a_(e.getMatrixStack());
        }
    }

    @Override
    public void drawToBackground(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (this.shouldCustomize(e.getGui())) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int width = e.getGui().field_230708_k_;
            int height = e.getGui().field_230709_l_;
            int j = width / 2 - 137;
            float minecraftLogoSpelling = RANDOM.nextFloat();
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            MatrixStack matrix = CurrentScreenHandler.getMatrixStack();
            RenderSystem.enableBlend();
            if (!this.canRenderBackground()) {
                this.panorama.func_217623_a(Minecraft.func_71410_x().func_193989_ak(), 1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/title/background/panorama_overlay.png"));
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IngameGui.func_238466_a_((MatrixStack)matrix, (int)0, (int)0, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            }
            super.drawToBackground(e);
            if (this.showLogo) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MINECRAFT_TITLE_TEXTURES);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if ((double)minecraftLogoSpelling < 1.0E-4) {
                    e.getGui().func_238474_b_(matrix, j + 0, 30, 0, 0, 99, 44);
                    e.getGui().func_238474_b_(matrix, j + 99, 30, 129, 0, 27, 44);
                    e.getGui().func_238474_b_(matrix, j + 99 + 26, 30, 126, 0, 3, 44);
                    e.getGui().func_238474_b_(matrix, j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                    e.getGui().func_238474_b_(matrix, j + 155, 30, 0, 45, 155, 44);
                } else {
                    e.getGui().func_238474_b_(matrix, j + 0, 30, 0, 0, 155, 44);
                    e.getGui().func_238474_b_(matrix, j + 155, 30, 0, 45, 155, 44);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(MINECRAFT_TITLE_EDITION);
                IngameGui.func_238463_a_((MatrixStack)matrix, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            }
            if (this.showBranding) {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                    int n = e.getGui().field_230709_l_;
                    int n2 = brdline;
                    font.getClass();
                    AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)font, (String)brd, (int)2, (int)(n - (10 + n2 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            if (this.showForgeNotificationTop) {
                ForgeHooksClient.renderMainMenu((MainMenuScreen)((MainMenuScreen)e.getGui()), (MatrixStack)matrix, (FontRenderer)font, (int)width, (int)height);
            }
            if (this.showForgeNotificationCopyright) {
                BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                    int n = e.getGui().field_230708_k_ - font.func_78256_a(brd) - 1;
                    int n2 = e.getGui().field_230709_l_;
                    int n3 = brdline + 1;
                    font.getClass();
                    AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)font, (String)brd, (int)n, (int)(n2 - (11 + n3 * (9 + 1))), (int)0xFFFFFF);
                });
            }
            String c = "Copyright Mojang AB. Do not distribute!";
            String cPos = (String)FancyMenu.config.getOrDefault("copyrightposition", (Object)"bottom-right");
            int cX = 0;
            int cY = 0;
            int cW = Minecraft.func_71410_x().field_71466_p.func_78256_a(c);
            int cH = 10;
            if (cPos.equalsIgnoreCase("top-left")) {
                cX = 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("top-centered")) {
                cX = width / 2 - cW / 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("top-right")) {
                cX = width - cW - 2;
                cY = 2;
            } else if (cPos.equalsIgnoreCase("bottom-left")) {
                cX = 2;
                cY = height - cH - 2;
            } else if (cPos.equalsIgnoreCase("bottom-centered")) {
                cX = width / 2 - cW / 2;
                cY = height - cH - 2;
            } else {
                cX = width - cW - 2;
                cY = height - cH - 2;
            }
            Color copyrightcolor = RenderUtils.getColorFromHexString((String)((String)FancyMenu.config.getOrDefault("copyrightcolor", (Object)"#ffffff")));
            if (copyrightcolor == null) {
                copyrightcolor = new Color(255, 255, 255);
            }
            AbstractGui.func_238476_c_((MatrixStack)matrix, (FontRenderer)font, (String)c, (int)cX, (int)cY, (int)(copyrightcolor.getRGB() | 0xFF000000));
            if (mouseX >= cX && mouseX <= cX + cW && mouseY >= cY && mouseY <= cY + cH) {
                IngameGui.func_238467_a_((MatrixStack)matrix, (int)cX, (int)(cY + cH - 1), (int)(cX + cW), (int)(cY + cH), (int)-1);
                if (MouseInput.isLeftMouseDown()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new WinGameScreen(false, Runnables.doNothing()));
                }
            }
            if (!PopupHandler.isPopupActive()) {
                this.renderButtons(e, mouseX, mouseY);
            }
            if (this.showRealmsNotification) {
                this.drawRealmsNotification(matrix, e.getGui());
            }
            this.renderSplash(matrix, e.getGui());
        }
    }

    protected void renderSplash(MatrixStack matrix, Screen s) {
        try {
            if (this.splashItem != null) {
                this.splashItem.render(matrix, s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderButtons(GuiScreenEvent.BackgroundDrawnEvent e, int mouseX, int mouseY) {
        List<Widget> buttons = this.getButtonList(e.getGui());
        float partial = Minecraft.func_71410_x().func_184121_ak();
        if (buttons != null) {
            for (int i = 0; i < buttons.size(); ++i) {
                buttons.get(i).func_230430_a_(CurrentScreenHandler.getMatrixStack(), mouseX, mouseY, partial);
            }
        }
    }

    private void drawRealmsNotification(MatrixStack matrix, Screen gui) {
        if (Minecraft.func_71410_x().field_71474_y.field_183509_X) {
            Screen realms = null;
            try {
                realms = ((IMixinMainMenuScreen)gui).getRealmsNotificationsScreenFancyMenu();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (realms != null) {
                realms.func_230430_a_(matrix, (int)Minecraft.func_71410_x().field_71417_B.func_198024_e(), (int)Minecraft.func_71410_x().field_71417_B.func_198026_f(), Minecraft.func_71410_x().func_184121_ak());
            }
        }
    }

    private List<Widget> getButtonList(Screen gui) {
        ArrayList<Widget> buttons = new ArrayList();
        try {
            buttons = ((IMixinScreen)gui).getButtonsFancyMenu();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buttons;
    }

    private void setWidthCopyrightRest(int i) {
        try {
            if (Minecraft.func_71410_x().field_71462_r instanceof MainMenuScreen) {
                ((IMixinMainMenuScreen)Minecraft.func_71410_x().field_71462_r).setCopyrightXFancyMenu(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void setShowFadeInAnimation(boolean showFadeIn, MainMenuScreen s) {
        try {
            ((IMixinMainMenuScreen)s).setFadingFancyMenu(showFadeIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

