/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.text;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.web.WebUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;

public class TextCustomizationItem
extends CustomizationItem {
    public SourceMode sourceMode = SourceMode.DIRECT;
    public String source;
    public boolean shadow = true;
    public CaseMode caseMode = CaseMode.NORMAL;
    public float scale = 1.0f;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public String baseColorHex = null;
    public int textBorder = 0;
    public int lineSpacing = 1;
    public String scrollGrabberTextureNormal = null;
    public String scrollGrabberTextureHover = null;
    public String scrollGrabberColorHexNormal = null;
    public String scrollGrabberColorHexHover = null;
    public boolean enableScrolling = true;
    protected FontRenderer font;
    public volatile ScrollArea scrollArea;
    public volatile LinkedListMultimap<String, Float> lines;
    public volatile boolean updating;
    public volatile int cachedTextWidth;

    public TextCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String lineSpacingString;
        String textBorderString;
        Color c;
        String baseColorString;
        CustomizationItemBase.Alignment a;
        String alignmentString;
        String scaleString;
        CaseMode c2;
        String caseModeString;
        String shadowString;
        SourceMode s;
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.lines = LinkedListMultimap.create();
        this.updating = false;
        this.cachedTextWidth = 0;
        this.source = item.getEntryValue("source");
        String sourceModeString = item.getEntryValue("source_mode");
        if (sourceModeString != null && (s = SourceMode.getByName(sourceModeString)) != null) {
            this.sourceMode = s;
        }
        if ((shadowString = item.getEntryValue("shadow")) != null && shadowString.equals("false")) {
            this.shadow = false;
        }
        if ((caseModeString = item.getEntryValue("case_mode")) != null && (c2 = CaseMode.getByName(caseModeString)) != null) {
            this.caseMode = c2;
        }
        if ((scaleString = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)scaleString)) {
            this.scale = Float.parseFloat(scaleString);
        }
        if ((alignmentString = item.getEntryValue("alignment")) != null && (a = CustomizationItemBase.Alignment.getByName(alignmentString)) != null) {
            this.alignment = a;
        }
        if ((baseColorString = item.getEntryValue("base_color")) != null && (c = RenderUtils.getColorFromHexString((String)baseColorString)) != null) {
            this.baseColorHex = baseColorString;
        }
        if ((textBorderString = item.getEntryValue("text_border")) != null && MathUtils.isInteger((String)textBorderString)) {
            this.textBorder = Integer.parseInt(textBorderString);
        }
        if ((lineSpacingString = item.getEntryValue("line_spacing")) != null && MathUtils.isInteger((String)lineSpacingString)) {
            this.lineSpacing = Integer.parseInt(lineSpacingString);
        }
        this.scrollGrabberColorHexNormal = item.getEntryValue("grabber_color_normal");
        this.scrollGrabberColorHexHover = item.getEntryValue("grabber_color_hover");
        this.scrollGrabberTextureNormal = item.getEntryValue("grabber_texture_normal");
        this.scrollGrabberTextureHover = item.getEntryValue("grabber_texture_hover");
        String enableScrollingString = item.getEntryValue("enable_scrolling");
        if (enableScrollingString != null && enableScrollingString.equals("false")) {
            this.enableScrolling = false;
        }
        this.updateContent();
    }

    public void updateScrollArea() {
        Object r;
        Color c;
        this.scrollArea = new ScrollArea(0, 0, this.width, this.height);
        this.scrollArea.backgroundColor = new Color(0, 0, 0, 0);
        this.scrollArea.enableScrolling = this.enableScrolling;
        if (this.scrollGrabberColorHexNormal != null && (c = RenderUtils.getColorFromHexString((String)this.scrollGrabberColorHexNormal)) != null) {
            this.scrollArea.grabberColorNormal = c;
        }
        if (this.scrollGrabberColorHexHover != null && (c = RenderUtils.getColorFromHexString((String)this.scrollGrabberColorHexHover)) != null) {
            this.scrollArea.grabberColorHover = c;
        }
        if (this.scrollGrabberTextureNormal != null && (r = TextureHandler.getResource((String)this.scrollGrabberTextureNormal)) != null) {
            this.scrollArea.grabberTextureNormal = r.getResourceLocation();
        }
        if (this.scrollGrabberTextureHover != null && (r = TextureHandler.getResource((String)this.scrollGrabberTextureHover)) != null) {
            this.scrollArea.grabberTextureHover = r.getResourceLocation();
        }
        for (Map.Entry m : this.lines.entries()) {
            TextElementLineEntry e = new TextElementLineEntry(this.scrollArea, this, (String)m.getKey(), false, this.scale * ((Float)m.getValue()).floatValue());
            this.scrollArea.addEntry((ScrollAreaEntry)e);
        }
        TextElementLineEntry e = new TextElementLineEntry(this.scrollArea, this, " ", false, 3.0f);
        this.scrollArea.addEntry((ScrollAreaEntry)e);
    }

    public Color getBaseColor() {
        if (this.baseColorHex != null) {
            return RenderUtils.getColorFromHexString((String)this.baseColorHex);
        }
        return null;
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        try {
            if (this.source != null) {
                this.value = this.source;
            }
            if (this.shouldRender()) {
                if (!this.updating) {
                    RenderSystem.enableBlend();
                    if (this.scrollArea != null) {
                        this.scrollArea.x = this.getPosX(menu);
                        this.scrollArea.y = this.getPosY(menu);
                        this.scrollArea.width = this.width;
                        this.scrollArea.height = this.height;
                        this.scrollArea.render(matrix);
                    }
                } else if (TextCustomizationItem.isEditorActive()) {
                    TextCustomizationItem.func_238467_a_((MatrixStack)matrix, (int)this.getPosX(menu), (int)this.getPosY(menu), (int)(this.getPosX(menu) + this.getWidth()), (int)(this.getPosY(menu) + this.getHeight()), (int)Color.MAGENTA.getRGB());
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    String string = Locals.localize((String)"fancymenu.customization.items.text.status.loading", (String[])new String[0]);
                    int n = this.getPosX(menu) + this.width / 2;
                    int n2 = this.getPosY(menu) + this.height / 2;
                    Minecraft.func_71410_x().field_71466_p.getClass();
                    TextCustomizationItem.func_238471_a_((MatrixStack)matrix, (FontRenderer)fontRenderer, (String)string, (int)n, (int)(n2 - 9 / 2), (int)-1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateContent() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        this.cachedTextWidth = 0;
        new Thread(() -> {
            ArrayList<String> linesRaw;
            block23: {
                linesRaw = new ArrayList<String>();
                try {
                    if (this.source != null && !this.source.equals("")) {
                        if (this.sourceMode == SourceMode.DIRECT) {
                            if (this.source.replace("\\n", "%n%").replace("\\r", "%n%").contains("%n%")) {
                                linesRaw.addAll(Arrays.asList(StringUtils.splitLines((String)this.source.replace("\\n", "%n%").replace("\\r", "%n%"), (String)"%n%")));
                            } else {
                                linesRaw.add(this.source);
                            }
                            break block23;
                        }
                        if (this.sourceMode == SourceMode.LOCAL_SOURCE) {
                            File f = new File(DynamicValueHelper.convertFromRaw(this.source));
                            if (f.isFile()) {
                                linesRaw.addAll(FileUtils.getFileLines((File)f));
                            }
                            break block23;
                        }
                        if (this.sourceMode != SourceMode.WEB_SOURCE) break block23;
                        if (WebUtils.isValidUrl((String)DynamicValueHelper.convertFromRaw(this.source))) {
                            String path;
                            String fixedSource = DynamicValueHelper.convertFromRaw(this.source);
                            if (fixedSource.toLowerCase().contains("/blob/") && (fixedSource.toLowerCase().startsWith("http://github.com/") || fixedSource.toLowerCase().startsWith("https://github.com/") || fixedSource.toLowerCase().startsWith("http://www.github.com/") || fixedSource.toLowerCase().startsWith("https://www.github.com/"))) {
                                path = fixedSource.replace("//", "").split("/", 2)[1].replace("/blob/", "/");
                                fixedSource = "https://raw.githubusercontent.com/" + path;
                            }
                            if (!fixedSource.toLowerCase().contains("/raw/") && (fixedSource.toLowerCase().startsWith("http://pastebin.com/") || fixedSource.toLowerCase().startsWith("https://pastebin.com/") || fixedSource.toLowerCase().startsWith("http://www.pastebin.com/") || fixedSource.toLowerCase().startsWith("https://www.pastebin.com/"))) {
                                path = fixedSource.replace("//", "").split("/", 2)[1];
                                fixedSource = "https://pastebin.com/raw/" + path;
                            }
                            BufferedReader r = null;
                            try {
                                URL url = new URL(fixedSource);
                                r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                                String s = r.readLine();
                                while (s != null) {
                                    linesRaw.add(s);
                                    s = r.readLine();
                                }
                                r.close();
                            }
                            catch (Exception e) {
                                if (r != null) {
                                    try {
                                        r.close();
                                    }
                                    catch (Exception e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                linesRaw.clear();
                            }
                            break block23;
                        }
                        linesRaw.clear();
                        break block23;
                    }
                    linesRaw.add(Locals.localize((String)"fancymenu.customization.items.text.placeholder", (String[])new String[0]));
                }
                catch (Exception e) {
                    linesRaw.clear();
                }
            }
            this.lines.clear();
            if (linesRaw.isEmpty()) {
                if (TextCustomizationItem.isEditorActive()) {
                    linesRaw.add(Locals.localize((String)"fancymenu.customization.items.text.status.unable_to_load", (String[])new String[0]));
                } else {
                    linesRaw.add("");
                }
            }
            for (String s : linesRaw) {
                float sc = TextCustomizationItem.getScaleMultiplicator(s);
                s = TextCustomizationItem.getWithoutHeadlineCodes(s);
                if (this.caseMode == CaseMode.ALL_LOWER) {
                    s = s.toLowerCase();
                }
                if (this.caseMode == CaseMode.ALL_UPPER) {
                    s = s.toUpperCase();
                }
                this.lines.put((Object)s, (Object)Float.valueOf(sc));
            }
            this.updateScrollArea();
            this.updating = false;
        }).start();
    }

    protected static float getScaleMultiplicator(String s) {
        if (s.startsWith("### ")) {
            return 1.1f;
        }
        if (s.startsWith("## ")) {
            return 1.3f;
        }
        if (s.startsWith("# ")) {
            return 1.5f;
        }
        return 1.0f;
    }

    protected static String getWithoutHeadlineCodes(String s) {
        if (s.startsWith("### ")) {
            return s.substring(4);
        }
        if (s.startsWith("## ")) {
            return s.substring(3);
        }
        if (s.startsWith("# ")) {
            return s.substring(2);
        }
        return s;
    }

    public static class TextElementLineEntry
    extends ScrollableScreen.ScrollAreaEntryBase {
        public String text;
        public boolean bold;
        public TextCustomizationItem parentItem;

        public TextElementLineEntry(ScrollArea parent, TextCustomizationItem parentItem, String text, boolean bold, float scale) {
            super(parent, null);
            this.parentItem = parentItem;
            this.text = text;
            this.bold = bold;
            Minecraft.func_71410_x().field_71466_p.getClass();
            this.setHeight((int)(9.0f * scale) + parentItem.lineSpacing);
            this.renderBody = render -> {
                if (this.text != null) {
                    FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                    String s = this.text;
                    if (this.bold) {
                        s = "\u00a7l" + this.text;
                    }
                    if (TextCustomizationItem.isEditorActive()) {
                        s = StringUtils.convertFormatCodes((String)s, (String)"&", (String)"\u00a7");
                    } else {
                        s = DynamicValueHelper.convertFromRaw(s);
                        s = DynamicValueHelper.convertFromRaw(s);
                    }
                    Color baseColor = this.parentItem.getBaseColor();
                    int color = -1;
                    if (baseColor != null) {
                        color = baseColor.getRGB();
                    }
                    if (!s.contains("%n%")) {
                        TextElementLineEntry.renderLine(s, font, scale, color, 0, this, render);
                    } else {
                        List<String> lines = Arrays.asList(StringUtils.splitLines((String)s, (String)"%n%"));
                        Minecraft.func_71410_x().field_71466_p.getClass();
                        this.setHeight((int)(9.0f * scale) * lines.size() + parentItem.lineSpacing + parentItem.lineSpacing * lines.size());
                        int i = 0;
                        for (String line : lines) {
                            TextElementLineEntry.renderLine(line, font, scale, color, i, this, render);
                            ++i;
                        }
                    }
                }
            };
        }

        protected static void renderLine(String s, FontRenderer font, float scale, int color, int line, TextElementLineEntry entry, ScrollableScreen.ScrollAreaEntryBase.EntryRenderCallback render) {
            float textWidth = (float)font.func_78256_a(s) * scale;
            int y = (int)((float)render.entry.y / scale);
            int x = (int)((float)render.entry.x / scale);
            if (entry.parentItem.alignment == CustomizationItemBase.Alignment.LEFT) {
                x += entry.parentItem.textBorder;
            }
            if (entry.parentItem.alignment == CustomizationItemBase.Alignment.RIGHT) {
                x = (int)((float)x + ((float)entry.getWidth() - textWidth) / scale);
                x -= entry.parentItem.textBorder;
            }
            if (entry.parentItem.alignment == CustomizationItemBase.Alignment.CENTERED) {
                x = (int)((float)x + ((float)entry.getWidth() - textWidth) / scale / 2.0f);
            }
            render.matrix.func_227860_a_();
            render.matrix.func_227862_a_(scale, scale, scale);
            int lineHeight = 10;
            float textY = y + lineHeight * line;
            if (entry.parentItem.lineSpacing > 0) {
                textY += (float)((int)((float)entry.parentItem.lineSpacing / scale * (float)line));
            }
            if (entry.parentItem.shadow) {
                font.func_238405_a_(render.matrix, s, (float)x, textY, color);
            } else {
                font.func_238421_b_(render.matrix, s, (float)x, textY, color);
            }
            render.matrix.func_227865_b_();
        }
    }

    public static enum CaseMode {
        NORMAL("normal"),
        ALL_LOWER("lower"),
        ALL_UPPER("upper");

        String name;

        private CaseMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static CaseMode getByName(String name) {
            for (CaseMode i : CaseMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }

    public static enum SourceMode {
        DIRECT("direct"),
        LOCAL_SOURCE("local"),
        WEB_SOURCE("web");

        String name;

        private SourceMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SourceMode getByName(String name) {
            for (SourceMode i : SourceMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

