/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.inputfield;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class InputFieldCustomizationItem
extends CustomizationItem {
    public String linkedVariable;
    public InputFieldType type = InputFieldType.TEXT;
    public int maxTextLength = 10000;
    public AdvancedTextField textField;
    public String lastValue = "";

    public InputFieldCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String var;
        String maxLengthString;
        InputFieldType t;
        this.linkedVariable = item.getEntryValue("linked_variable");
        String inputFieldTypeString = item.getEntryValue("input_field_type");
        if (inputFieldTypeString != null && (t = InputFieldType.getByName(inputFieldTypeString)) != null) {
            this.type = t;
        }
        if ((maxLengthString = item.getEntryValue("max_text_length")) != null && MathUtils.isInteger((String)maxLengthString)) {
            this.maxTextLength = Integer.parseInt(maxLengthString);
        }
        if (this.maxTextLength <= 0) {
            this.maxTextLength = 1;
        }
        Screen current = Minecraft.func_71410_x().field_71462_r;
        this.textField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, this.getPosX(current), this.getPosY(current), this.width, this.height, true, this.type.filter);
        this.textField.func_146203_f(this.maxTextLength);
        if (this.linkedVariable != null && (var = VariableHandler.getVariable(this.linkedVariable)) != null) {
            this.textField.func_146180_a(var);
        }
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (this.shouldRender()) {
            RenderSystem.enableBlend();
            if (InputFieldCustomizationItem.isEditorActive()) {
                String var;
                this.textField.field_230693_o_ = false;
                this.textField.func_146184_c(false);
                if (this.linkedVariable != null && (var = VariableHandler.getVariable(this.linkedVariable)) != null) {
                    this.textField.func_146180_a(var);
                }
            }
            this.textField.field_230690_l_ = this.getPosX(menu);
            this.textField.field_230691_m_ = this.getPosY(menu);
            this.textField.func_230991_b_(this.width);
            this.textField.setHeight(this.height);
            this.textField.func_230430_a_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_184121_ak());
            if (!InputFieldCustomizationItem.isEditorActive()) {
                if (this.linkedVariable != null) {
                    String val;
                    if (!this.lastValue.equals(this.textField.func_146179_b())) {
                        VariableHandler.setVariable(this.linkedVariable, this.textField.func_146179_b());
                    }
                    if ((val = VariableHandler.getVariable(this.linkedVariable)) != null && !this.textField.func_146179_b().equals(val)) {
                        this.textField.func_146180_a(val);
                    }
                }
                this.lastValue = this.textField.func_146179_b();
            }
        }
    }

    public static enum InputFieldType {
        INTEGER_ONLY("integer", CharacterFilter.getIntegerCharacterFiler()),
        DECIMAL_ONLY("decimal", CharacterFilter.getDoubleCharacterFiler()),
        URL("url", CharacterFilter.getUrlCharacterFilter()),
        TEXT("text", null);

        String name;
        CharacterFilter filter;

        private InputFieldType(String name, CharacterFilter filter) {
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public CharacterFilter getFilter() {
            return this.filter;
        }

        public static InputFieldType getByName(String name) {
            for (InputFieldType i : InputFieldType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

