/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;

public class WebStringCustomizationItem
extends CustomizationItemBase {
    public volatile LinkedListMultimap<String, Float> lines = LinkedListMultimap.create();
    private volatile boolean updating = false;
    public boolean multiline = false;
    public boolean shadow = false;
    public float scale = 1.0f;
    public CustomizationItemBase.Alignment alignment = CustomizationItemBase.Alignment.LEFT;
    public String rawURL = "";
    protected volatile int unscaledHeight = 1;
    protected volatile int unscaledWidth = 1;
    protected FontRenderer font;

    public WebStringCustomizationItem(PropertiesSection item) {
        super(item);
        this.font = Minecraft.func_71410_x().field_71466_p;
        if (this.action != null && this.action.equalsIgnoreCase("addwebtext")) {
            String al;
            String sc;
            String sh;
            String multi;
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = DynamicValueHelper.convertFromRaw(this.value);
            }
            if ((multi = item.getEntryValue("multiline")) != null && multi.equalsIgnoreCase("true")) {
                this.multiline = true;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("true")) {
                this.shadow = true;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((al = item.getEntryValue("alignment")) != null) {
                if (al.equalsIgnoreCase("right")) {
                    this.alignment = CustomizationItemBase.Alignment.RIGHT;
                }
                if (al.equalsIgnoreCase("centered")) {
                    this.alignment = CustomizationItemBase.Alignment.CENTERED;
                }
            }
            this.updateContent(this.value);
        }
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (!this.shouldRender()) {
            return;
        }
        if (!this.updating) {
            RenderSystem.enableBlend();
            this.setWidth((int)((float)this.unscaledWidth * this.scale));
            this.setHeight((int)((float)this.unscaledHeight * this.scale));
            int i = 0;
            for (Map.Entry m : this.lines.entries()) {
                float sc = this.scale * ((Float)m.getValue()).floatValue();
                int x = (int)((float)this.getPosX(menu) / sc);
                int y = (int)((float)this.getPosY(menu) / sc);
                int stringwidth = (int)((float)this.font.func_78256_a((String)m.getKey()) * sc);
                if (this.alignment == CustomizationItemBase.Alignment.RIGHT) {
                    x = (int)((float)x + (float)(this.getWidth() - stringwidth) / sc);
                }
                if (this.alignment == CustomizationItemBase.Alignment.CENTERED) {
                    x = (int)((float)x + (float)(this.getWidth() - stringwidth) / sc / 2.0f);
                }
                matrix.func_227860_a_();
                matrix.func_227862_a_(sc, sc, sc);
                if (this.shadow) {
                    this.font.func_238405_a_(matrix, "\u00a7f" + (String)m.getKey(), (float)x, (float)y + (float)i / sc, 0 | MathHelper.func_76123_f((float)(this.opacity * 255.0f)) << 24);
                } else {
                    this.font.func_238421_b_(matrix, "\u00a7f" + (String)m.getKey(), (float)x, (float)y + (float)i / sc, 0 | MathHelper.func_76123_f((float)(this.opacity * 255.0f)) << 24);
                }
                matrix.func_227865_b_();
                i = (int)((float)i + 10.0f * sc);
            }
            RenderSystem.disableBlend();
        }
    }

    @Override
    public int getPosX(Screen menu) {
        int x = super.getPosX(menu);
        if (this.alignment == CustomizationItemBase.Alignment.CENTERED) {
            x -= this.getWidth() / 2;
        } else if (this.alignment == CustomizationItemBase.Alignment.RIGHT) {
            x -= this.getWidth();
        }
        return x;
    }

    @Override
    public boolean shouldRender() {
        if (this.lines == null || this.lines.isEmpty()) {
            return false;
        }
        return super.shouldRender();
    }

    public void updateContent(final String url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebStringCustomizationItem.this.updating = true;
                String old = WebStringCustomizationItem.this.value;
                int w = 1;
                int h = 1;
                WebStringCustomizationItem.this.value = url;
                if (WebStringCustomizationItem.this.isValidUrl()) {
                    String path;
                    if (WebStringCustomizationItem.this.value.toLowerCase().contains("/blob/") && (WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://www.github.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://www.github.com/"))) {
                        path = WebStringCustomizationItem.this.value.replace("//", "").split("/", 2)[1].replace("/blob/", "/");
                        WebStringCustomizationItem.this.value = "https://raw.githubusercontent.com/" + path;
                    }
                    if (!WebStringCustomizationItem.this.value.toLowerCase().contains("/raw/") && (WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("http://www.pastebin.com/") || WebStringCustomizationItem.this.value.toLowerCase().startsWith("https://www.pastebin.com/"))) {
                        path = WebStringCustomizationItem.this.value.replace("//", "").split("/", 2)[1];
                        WebStringCustomizationItem.this.value = "https://pastebin.com/raw/" + path;
                    }
                    try {
                        WebStringCustomizationItem.this.lines.clear();
                        URL u = new URL(WebStringCustomizationItem.this.value);
                        BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8));
                        String s = r.readLine();
                        while (s != null) {
                            s = CustomizationItemBase.isEditorActive() ? StringUtils.convertFormatCodes((String)s, (String)"&", (String)"\u00a7") : DynamicValueHelper.convertFromRaw(s);
                            float sc = WebStringCustomizationItem.getScaleMultiplicator(s);
                            int i = (int)((float)WebStringCustomizationItem.this.font.func_78256_a(s = WebStringCustomizationItem.getWithoutHeadlineCodes(s)) * sc);
                            if (i > w) {
                                w = i;
                            }
                            h = (int)((float)h + 10.0f * sc);
                            WebStringCustomizationItem.this.lines.put((Object)s, (Object)Float.valueOf(sc));
                            if (!WebStringCustomizationItem.this.multiline) break;
                            s = r.readLine();
                        }
                        r.close();
                        WebStringCustomizationItem.this.unscaledWidth = w;
                        WebStringCustomizationItem.this.unscaledHeight = h;
                    }
                    catch (Exception e) {
                        WebStringCustomizationItem.this.lines.clear();
                        String s = "";
                        if (CustomizationItemBase.isEditorActive()) {
                            s = Locals.localize((String)"customization.items.webstring.unabletoload", (String[])new String[0]);
                        }
                        WebStringCustomizationItem.this.lines.put((Object)s, (Object)Float.valueOf(1.0f));
                        WebStringCustomizationItem.this.unscaledWidth = WebStringCustomizationItem.this.font.func_78256_a(s);
                        WebStringCustomizationItem.this.unscaledHeight = 10;
                        e.printStackTrace();
                    }
                } else {
                    WebStringCustomizationItem.this.lines.clear();
                    String s = "";
                    if (CustomizationItemBase.isEditorActive()) {
                        s = Locals.localize((String)"customization.items.webstring.unabletoload", (String[])new String[0]);
                    }
                    WebStringCustomizationItem.this.lines.put((Object)s, (Object)Float.valueOf(1.0f));
                    WebStringCustomizationItem.this.unscaledWidth = WebStringCustomizationItem.this.font.func_78256_a(s);
                    WebStringCustomizationItem.this.unscaledHeight = 10;
                    System.out.println("########################## ERROR ##########################");
                    System.out.println("[FM] Cannot load text content from " + WebStringCustomizationItem.this.value + "! Invalid URL!");
                    System.out.println("###########################################################");
                    WebStringCustomizationItem.this.value = old;
                }
                WebStringCustomizationItem.this.updating = false;
            }
        }).start();
    }

    protected static float getScaleMultiplicator(String s) {
        if (s.startsWith("### ")) {
            return 1.1f;
        }
        if (s.startsWith("## ")) {
            return 1.3f;
        }
        if (s.startsWith("# ")) {
            return 1.5f;
        }
        return 1.0f;
    }

    protected static String getWithoutHeadlineCodes(String s) {
        if (s.startsWith("### ")) {
            return s.substring(4);
        }
        if (s.startsWith("## ")) {
            return s.substring(3);
        }
        if (s.startsWith("# ")) {
            return s.substring(2);
        }
        return s;
    }

    private boolean isValidUrl() {
        if (this.value == null || !this.value.startsWith("http://") && !this.value.startsWith("https://")) {
            return false;
        }
        try {
            URL url = new URL(this.value);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setRequestMethod("HEAD");
            int r = c.getResponseCode();
            if (r == 200) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Trying alternative method to check for existing url..");
            try {
                URL url = new URL(this.value);
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }
}

