/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;

public class TextureCustomizationItem
extends CustomizationItemBase {
    public ExternalTextureResourceLocation texture;
    public ExternalGifAnimationRenderer gif;

    public TextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtexture")) {
            this.value = TextureCustomizationItem.fixBackslashPath(item.getEntryValue("path"));
            if (this.value != null) {
                this.value = this.value.replace("\\", "/");
                File f = new File(this.value);
                if (f.exists() && f.isFile() && (f.getName().endsWith(".png") || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".gif"))) {
                    try {
                        int w = 0;
                        int h = 0;
                        if (f.getName().endsWith(".gif")) {
                            this.gif = TextureHandler.getGifResource((String)this.value);
                            if (this.gif != null) {
                                w = this.gif.getWidth();
                                h = this.gif.getHeight();
                            }
                        } else {
                            this.texture = TextureHandler.getResource((String)this.value);
                            if (this.texture != null) {
                                w = this.texture.getWidth();
                                h = this.texture.getHeight();
                            }
                        }
                        double ratio = (double)w / (double)h;
                        if (this.getWidth() < 0 && this.getHeight() >= 0) {
                            this.setWidth((int)((double)this.getHeight() * ratio));
                        }
                        if (this.getHeight() < 0 && this.getWidth() >= 0) {
                            this.setHeight((int)((double)this.getWidth() / ratio));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (this.shouldRender()) {
            int x = this.getPosX(menu);
            int y = this.getPosY(menu);
            if (this.gif != null) {
                int w = this.gif.getWidth();
                int h = this.gif.getHeight();
                int x2 = this.gif.getPosX();
                int y2 = this.gif.getPosY();
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                this.gif.setPosX(x);
                this.gif.setPosY(y);
                this.gif.setWidth(this.getWidth());
                this.gif.setHeight(this.getHeight());
                this.gif.setOpacity(this.opacity);
                this.gif.render(matrix);
                this.gif.setPosX(x2);
                this.gif.setPosY(y2);
                this.gif.setWidth(w);
                this.gif.setHeight(h);
                RenderSystem.disableBlend();
            } else if (this.texture != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture.getResourceLocation());
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                IngameGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (int)this.getWidth(), (int)this.getHeight());
                RenderSystem.disableBlend();
            }
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.texture == null && this.gif == null) {
            return false;
        }
        if (this.getWidth() < 0 || this.getHeight() < 0) {
            return false;
        }
        return super.shouldRender();
    }
}

