/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SplashTextCustomizationItem
extends CustomizationItemBase {
    protected static Map<String, String> splashCache = new HashMap<String, String>();
    protected static boolean init = false;
    public float scale = 1.0f;
    public boolean shadow = true;
    public boolean bounce = true;
    public float rotation = 20.0f;
    public Color basecolor = new Color(255, 255, 0);
    public String basecolorString = "#ffff00";
    public boolean refreshOnMenuReload = false;
    public File splashfile;
    public String text = null;
    public boolean vanillaLike = false;
    protected float basescale = 1.8f;
    protected static boolean isNewMenu = false;
    protected boolean isNewMenuThis = false;
    protected static Screen lastScreen = null;
    protected static Map<String, String> vanillaLikeCache = new HashMap<String, String>();

    public SplashTextCustomizationItem(PropertiesSection item) {
        super(item);
        if (!init) {
            MinecraftForge.EVENT_BUS.register(SplashTextCustomizationItem.class);
            init = true;
        }
        if (this.action != null && this.action.equalsIgnoreCase("addsplash")) {
            String b;
            String sc;
            String sh;
            Color c;
            String co;
            String re;
            String filepath;
            String vanillaLikeString = item.getEntryValue("vanilla-like");
            if (vanillaLikeString != null && vanillaLikeString.equals("true")) {
                this.vanillaLike = true;
            }
            if ((filepath = SplashTextCustomizationItem.fixBackslashPath(item.getEntryValue("splashfilepath"))) != null) {
                this.splashfile = new File(filepath);
                if (!this.splashfile.exists() || !this.splashfile.getPath().toLowerCase().endsWith(".txt")) {
                    this.splashfile = null;
                }
            }
            if (!this.vanillaLike) {
                this.text = item.getEntryValue("text");
            } else if (vanillaLikeCache.containsKey(this.actionId)) {
                this.text = vanillaLikeCache.get(this.actionId);
            }
            String ro = item.getEntryValue("rotation");
            if (ro != null && MathUtils.isFloat((String)ro)) {
                this.rotation = Float.parseFloat(ro);
            }
            if ((re = item.getEntryValue("refresh")) != null && re.equalsIgnoreCase("true")) {
                this.refreshOnMenuReload = true;
            }
            if ((co = item.getEntryValue("basecolor")) != null && (c = RenderUtils.getColorFromHexString((String)co)) != null) {
                this.basecolor = c;
                this.basecolorString = co;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("false")) {
                this.shadow = false;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((b = item.getEntryValue("bouncing")) != null && b.equalsIgnoreCase("false")) {
                this.bounce = false;
            }
            this.value = "splash text";
            this.setWidth((int)(30.0f * this.basescale * this.scale));
            this.setHeight((int)(10.0f * this.basescale * this.scale));
        }
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        if (this.isNewMenuThis) {
            isNewMenu = false;
        }
        this.isNewMenuThis = isNewMenu;
        this.setWidth((int)(30.0f * this.basescale * this.scale));
        this.setHeight((int)(10.0f * this.basescale * this.scale));
        if (this.shouldRender()) {
            this.renderSplash(matrix, Minecraft.func_71410_x().field_71466_p, menu);
        }
    }

    protected void renderSplash(MatrixStack matrix, FontRenderer font, Screen s) {
        String splash = null;
        if (this.vanillaLike && this.text == null) {
            this.text = Minecraft.func_71410_x().func_213269_at().func_215276_a();
            vanillaLikeCache.put(this.actionId, this.text);
        }
        if (this.splashfile != null && this.text == null) {
            List l;
            if (isNewMenu && this.refreshOnMenuReload) {
                splashCache.remove(this.getActionId());
            }
            if (!splashCache.containsKey(this.getActionId()) && !(l = FileUtils.getFileLines((File)this.splashfile)).isEmpty()) {
                int i = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                splashCache.put(this.getActionId(), (String)l.get(i));
            }
            if (splashCache.containsKey(this.getActionId())) {
                splash = splashCache.get(this.getActionId());
            }
        }
        if (this.text != null) {
            splash = this.text;
        }
        if (splash != null) {
            if (this.value != null) {
                splash = !SplashTextCustomizationItem.isEditorActive() ? DynamicValueHelper.convertFromRaw(splash) : StringUtils.convertFormatCodes((String)splash, (String)"&", (String)"\u00a7");
            }
            this.value = splash;
            float f = this.basescale;
            if (this.bounce) {
                f -= MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Util.func_211177_b() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            }
            f = f * 100.0f / (float)(font.func_78256_a(splash) + 32);
            RenderSystem.enableBlend();
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)((float)(this.getPosX(s) + this.getWidth() / 2) / this.scale), (float)((float)this.getPosY(s) / this.scale), (float)0.0f);
            RenderSystem.rotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.scalef((float)f, (float)f, (float)f);
            int alpha = this.basecolor.getAlpha();
            int i = MathHelper.func_76123_f((float)(this.opacity * 255.0f));
            if (i < alpha) {
                alpha = i;
            }
            Color c = new Color(this.basecolor.getRed(), this.basecolor.getGreen(), this.basecolor.getBlue(), alpha);
            if (this.shadow) {
                font.func_238405_a_(matrix, splash, (float)(-(font.func_78256_a(splash) / 2)), 0.0f, c.getRGB());
            } else {
                font.func_238421_b_(matrix, splash, (float)(-(font.func_78256_a(splash) / 2)), 0.0f, c.getRGB());
            }
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onInitScreenPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (!(s == null || lastScreen != null && lastScreen.getClass().getName().equals(s.getClass().getName()))) {
            isNewMenu = true;
        }
        lastScreen = s;
    }

    @SubscribeEvent
    public static void onMenuReloaded(MenuReloadedEvent e) {
        splashCache.clear();
    }
}

