/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.ContextMenu;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class FMContextMenu
extends ContextMenu {
    protected boolean resetParentButtonOnClose = false;
    protected int cachedScreenWidth = 0;
    protected int cachedScreenHeight = 0;
    protected List<Integer> separators = new ArrayList<Integer>();

    public FMContextMenu() {
        super(20, 20, 0);
    }

    public void addContent(AdvancedButton button) {
        super.addContent(button);
        Color c = new Color(0, 0, 0, 0);
        button.setBackgroundColor(UIBase.getButtonIdleColor(), UIBase.getButtonHoverColor(), c, c, 0);
    }

    public void addSeparator() {
        int i = this.content.size();
        if (!this.separators.contains(i)) {
            this.separators.add(i);
        }
    }

    public void openMenuAt(int x, int y, int screenWidth, int screenHeight) {
        for (AdvancedButton b : this.content) {
            b.setLabelShadow(false);
        }
        this.cachedScreenWidth = screenWidth;
        this.cachedScreenHeight = screenHeight;
        if (this.parent != null && this.parent instanceof FMContextMenu) {
            screenWidth = ((FMContextMenu)this.parent).cachedScreenWidth;
            screenHeight = ((FMContextMenu)this.parent).cachedScreenHeight;
        }
        int i = 20;
        for (AdvancedButton b : this.content) {
            int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(b.getMessageString()) + 12;
            if (b.func_230998_h_() > sw) {
                sw = b.func_230998_h_();
            }
            if (sw <= i) continue;
            i = sw;
        }
        this.width = i;
        super.openMenuAt(x, y, screenWidth, screenHeight);
    }

    public void render(MatrixStack matrix, int mouseX, int mouseY, int screenWidth, int screenHeight) {
        if (this.parent != null && this.parent instanceof FMContextMenu) {
            screenWidth = ((FMContextMenu)this.parent).cachedScreenWidth;
            screenHeight = ((FMContextMenu)this.parent).cachedScreenHeight;
        }
        super.render(matrix, mouseX, mouseY, screenWidth, screenHeight);
        if (this.opened) {
            if (this.alwaysOnTop) {
                RenderUtils.setZLevelPre((MatrixStack)matrix, (int)400);
                this.renderBorder(matrix);
                this.renderSeparators(matrix);
                RenderUtils.setZLevelPost((MatrixStack)matrix);
            } else {
                this.renderBorder(matrix);
                this.renderSeparators(matrix);
            }
        } else if (this.resetParentButtonOnClose) {
            this.parentButton = null;
        }
    }

    protected void renderSeparators(MatrixStack matrix) {
        if (!this.content.isEmpty()) {
            for (Integer i : this.separators) {
                if (this.content.size() < i + 1) continue;
                AdvancedButton b = (AdvancedButton)this.content.get(i);
                Color c = new Color(UIBase.getButtonBorderIdleColor().getRed(), UIBase.getButtonBorderIdleColor().getGreen(), UIBase.getButtonBorderIdleColor().getBlue(), 100);
                UIBase.func_238467_a_((MatrixStack)matrix, (int)b.field_230690_l_, (int)b.field_230691_m_, (int)(b.field_230690_l_ + this.width), (int)(b.field_230691_m_ + 1), (int)c.getRGB());
            }
        }
    }

    protected void renderBorder(MatrixStack matrix) {
        if (!this.content.isEmpty()) {
            AdvancedButton b = (AdvancedButton)this.content.get(0);
            UIBase.func_238467_a_((MatrixStack)matrix, (int)b.field_230690_l_, (int)b.field_230691_m_, (int)(b.field_230690_l_ + this.width), (int)(b.field_230691_m_ + 1), (int)UIBase.getButtonBorderIdleColor().getRGB());
            UIBase.func_238467_a_((MatrixStack)matrix, (int)b.field_230690_l_, (int)(b.field_230691_m_ + 1), (int)(b.field_230690_l_ + 1), (int)(b.field_230691_m_ + this.lastHeight), (int)UIBase.getButtonBorderIdleColor().getRGB());
            UIBase.func_238467_a_((MatrixStack)matrix, (int)(b.field_230690_l_ + 1), (int)(b.field_230691_m_ + this.lastHeight - 1), (int)(b.field_230690_l_ + this.width), (int)(b.field_230691_m_ + this.lastHeight), (int)UIBase.getButtonBorderIdleColor().getRGB());
            UIBase.func_238467_a_((MatrixStack)matrix, (int)(b.field_230690_l_ + this.width - 1), (int)(b.field_230691_m_ + 1), (int)(b.field_230690_l_ + this.width), (int)(b.field_230691_m_ + this.lastHeight - 1), (int)UIBase.getButtonBorderIdleColor().getRGB());
        }
    }

    public List<AdvancedButton> getContent() {
        return this.content;
    }

    public void resetParentButtonOnClose(boolean reset) {
        this.resetParentButtonOnClose = reset;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isHovered() {
        for (ContextMenu c : this.children) {
            if (!c.isHovered()) continue;
            return true;
        }
        return super.isHovered();
    }
}

