/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.api.visibilityrequirements.VisibilityRequirement;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements.LegacyVisibilityRequirements;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.visibilityrequirements.VisibilityRequirementContainer;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;

public class VisibilityRequirementsScreen
extends ScrollableScreen {
    protected static final Color ENTRY_BACK_1 = new Color(0, 0, 0, 50);
    protected static final Color ENTRY_BACK_2 = new Color(0, 0, 0, 90);
    public CustomizationItemBase parentItem;
    protected int entryBackTick = 0;
    protected AdvancedButton doneButton;

    public VisibilityRequirementsScreen(Screen parent, CustomizationItemBase parentItem) {
        super(parent, Locals.localize((String)"fancymenu.helper.ui.visibility_requirements.manage", (String[])new String[0]));
        this.parentItem = parentItem;
        this.doneButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, press -> Minecraft.func_71410_x().func_147108_a(this.parent));
        this.doneButton.ignoreLeftMouseDownClickBlock = true;
        UIBase.colorizeButton(this.doneButton);
        VisibilityRequirementContainer c = this.parentItem.visibilityRequirementContainer;
        LegacyVisibilityRequirements.getLegacyRequirements(this, c).forEach(req -> this.addRequirement((Requirement)((Object)req)));
        for (VisibilityRequirementContainer.RequirementPackage p : c.customRequirements.values()) {
            VisibilityRequirement v = p.requirement;
            String valuePreset = null;
            if (v.hasValue()) {
                valuePreset = v.getValuePreset();
                if (valuePreset == null) {
                    valuePreset = "";
                }
                if (p.value != null) {
                    valuePreset = p.value;
                }
            }
            Consumer<String> valueCallback = null;
            if (v.hasValue()) {
                valueCallback = call -> {
                    p.value = call;
                };
            }
            CharacterFilter charFilter = v.getValueInputFieldFilter();
            String desc = "";
            for (String s : v.getDescription()) {
                if (s.equalsIgnoreCase("")) {
                    s = " ";
                }
                if (desc.equalsIgnoreCase("")) {
                    desc = desc + s;
                    continue;
                }
                desc = desc + "%n%" + s;
            }
            Requirement req2 = new Requirement(this, v.getDisplayName(), desc, v.getValueDisplayName(), p.checkFor, p.showIf, enabledCallback -> {
                p.checkFor = enabledCallback;
            }, showIfCallback -> {
                p.showIf = showIfCallback;
            }, valueCallback, charFilter, valuePreset);
            this.addRequirement(req2);
        }
    }

    @Override
    public boolean isOverlayButtonHovered() {
        return this.doneButton.func_230449_g_();
    }

    protected void addRequirement(Requirement requirement) {
        if (this.entryBackTick == 0) {
            this.scrollArea.addEntry((ScrollAreaEntry)new RequirementScrollEntry(this.scrollArea, requirement, ENTRY_BACK_1));
            this.entryBackTick = 1;
        } else {
            this.scrollArea.addEntry((ScrollAreaEntry)new RequirementScrollEntry(this.scrollArea, requirement, ENTRY_BACK_2));
            this.entryBackTick = 0;
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.SeparatorEntry(this.scrollArea, 1, new Color(255, 255, 255, 100)));
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        int xCenter = this.field_230708_k_ / 2;
        this.doneButton.setX(xCenter - this.doneButton.func_230998_h_() / 2);
        this.doneButton.setY(this.field_230709_l_ - 35);
        this.doneButton.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    public static class Requirement
    extends AbstractGui {
        protected VisibilityRequirementsScreen parent;
        protected String name;
        protected String desc;
        protected String valueName;
        protected Consumer<Boolean> enabledCallback;
        protected Consumer<Boolean> showIfCallback;
        protected Consumer<String> valueCallback;
        protected CharacterFilter valueFilter;
        protected boolean enabled;
        protected boolean showIf;
        protected String valueString;
        protected boolean hasValue = false;
        protected List<Runnable> preRenderTasks = new ArrayList<Runnable>();
        protected List<AdvancedButton> buttonList = new ArrayList<AdvancedButton>();
        protected AdvancedButton enableRequirementButton;
        protected AdvancedButton showIfButton;
        protected AdvancedButton showIfNotButton;
        protected AdvancedTextField valueTextField;

        public Requirement(VisibilityRequirementsScreen parent, String name, String desc, @Nullable String valueName, boolean enabled, boolean showIf, Consumer<Boolean> enabledCallback, Consumer<Boolean> showIfCallback, @Nullable Consumer<String> valueCallback, CharacterFilter valueFilter, String valueString) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueName = valueName;
            this.enabledCallback = enabledCallback;
            this.showIfCallback = showIfCallback;
            this.valueCallback = valueCallback;
            this.valueFilter = valueFilter;
            this.enabled = enabled;
            this.showIf = showIf;
            this.valueString = valueString;
            this.init();
        }

        protected void init() {
            String enabledString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.enabled", (String[])new String[]{this.name});
            if (!this.enabled) {
                enabledString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.disabled", (String[])new String[]{this.name});
            }
            this.enableRequirementButton = new AdvancedButton(0, 0, 150, 20, enabledString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    if (this.enabled) {
                        this.enabled = false;
                        this.enabledCallback.accept(false);
                        ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.disabled", (String[])new String[]{this.name}));
                    } else {
                        this.enabled = true;
                        this.enabledCallback.accept(true);
                        ((AdvancedButton)press).setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.enabled", (String[])new String[]{this.name}));
                    }
                }
            });
            ArrayList<String> descLines = new ArrayList<String>();
            descLines.addAll(Arrays.asList(StringUtils.splitLines((String)this.desc, (String)"%n%")));
            descLines.add("");
            descLines.add(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.toggle.btn.desc", (String[])new String[0]));
            this.enableRequirementButton.setDescription(descLines.toArray(new String[0]));
            this.preRenderTasks.add(() -> this.enableRequirementButton.func_230991_b_(Minecraft.func_71410_x().field_71466_p.func_78256_a(this.enableRequirementButton.func_230458_i_().func_150261_e()) + 10));
            this.addButton(this.enableRequirementButton);
            String showIfString = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
            if (!this.showIf) {
                showIfString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]);
            }
            this.showIfButton = new AdvancedButton(0, 0, 100, 20, showIfString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    this.showIf = true;
                    this.showIfCallback.accept(true);
                    ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]));
                    this.showIfNotButton.setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]));
                }
            });
            this.showIfButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfButton);
            String showIfNotString = "\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
            if (this.showIf) {
                showIfNotString = Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]);
            }
            this.showIfNotButton = new AdvancedButton(0, 0, 100, 20, showIfNotString, true, press -> {
                if (!this.parent.isOverlayButtonHovered()) {
                    this.showIf = false;
                    this.showIfCallback.accept(false);
                    ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot", (String[])new String[0]));
                    this.showIfButton.setMessage(Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showif", (String[])new String[0]));
                }
            });
            this.showIfNotButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.items.visibilityrequirements.showifnot.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfNotButton);
            if (this.valueCallback != null && this.valueName != null) {
                this.hasValue = true;
                this.valueTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 150, 20, true, this.valueFilter);
                this.valueTextField.func_146205_d(true);
                this.valueTextField.func_146195_b(false);
                this.valueTextField.func_146203_f(1000);
                if (this.valueString != null) {
                    this.valueTextField.func_146180_a(this.valueString);
                }
            }
        }

        public void render(MatrixStack matrix, int mouseX, int mouseY, RequirementScrollEntry entry) {
            for (Runnable r : this.preRenderTasks) {
                r.run();
            }
            float partial = Minecraft.func_71410_x().func_184121_ak();
            int originX = entry.x + entry.getWidth() / 2;
            int originY = entry.y + entry.getHeight() / 2;
            originY = this.hasValue ? (originY += 23) : (originY += 45);
            this.enableRequirementButton.field_230690_l_ = originX - this.enableRequirementButton.func_230998_h_() / 2;
            this.enableRequirementButton.field_230691_m_ = originY - 70;
            this.showIfButton.field_230690_l_ = originX - this.showIfButton.func_230998_h_() - 5;
            this.showIfButton.field_230691_m_ = originY - 40;
            this.showIfNotButton.field_230693_o_ = this.enabled;
            this.showIfNotButton.field_230690_l_ = originX + 5;
            this.showIfNotButton.field_230691_m_ = originY - 40;
            this.showIfButton.field_230693_o_ = this.enabled;
            if (this.valueTextField != null) {
                Requirement.func_238471_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(this.valueName + ":"), (int)originX, (int)(originY - 10), (int)-1);
                this.valueTextField.field_230690_l_ = originX - this.valueTextField.func_230998_h_() / 2;
                this.valueTextField.field_230691_m_ = originY + 3;
                this.valueTextField.func_230430_a_(matrix, mouseX, mouseY, partial);
                this.valueTextField.field_230693_o_ = this.enabled;
                this.valueTextField.func_146184_c(this.enabled);
                this.valueCallback.accept(this.valueTextField.func_146179_b());
                this.valueString = this.valueTextField.func_146179_b();
            }
            this.renderButtons(matrix, mouseX, mouseY, partial);
        }

        protected void renderButtons(MatrixStack matrix, int mouseX, int mouseY, float partial) {
            for (AdvancedButton b : this.buttonList) {
                b.func_230430_a_(matrix, mouseX, mouseY, partial);
            }
        }

        protected void addButton(AdvancedButton b) {
            if (!this.buttonList.contains(b)) {
                this.buttonList.add(b);
                UIBase.colorizeButton(b);
            }
        }
    }

    public static class RequirementScrollEntry
    extends ScrollableScreen.ScrollAreaEntryBase {
        public Requirement requirement;
        public boolean hasValue = false;
        public Color backgroundColor;

        public RequirementScrollEntry(ScrollArea parent, Requirement requirement, Color backgroundColor) {
            super(parent, call -> {});
            this.requirement = requirement;
            this.backgroundColor = backgroundColor;
            if (requirement.valueCallback != null && requirement.valueName != null) {
                this.hasValue = true;
                this.setHeight(110);
            } else {
                this.setHeight(66);
            }
        }

        @Override
        public void renderEntry(MatrixStack matrix) {
            super.renderEntry(matrix);
            RequirementScrollEntry.func_238467_a_((MatrixStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)this.backgroundColor.getRGB());
            this.requirement.render(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), this);
        }
    }
}

