/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.fancy.helper.DynamicValueInputPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.LayoutElement;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMTextInputPopup;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.StringCustomizationItem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;

public class LayoutString
extends LayoutElement {
    protected AdvancedButton alignmentLeftBtn;
    protected AdvancedButton alignmentRightBtn;
    protected AdvancedButton alignmentCenteredBtn;

    public LayoutString(StringCustomizationItem parent, LayoutEditorScreen handler) {
        super(parent, true, handler);
        this.setScale(this.getStringScale());
    }

    @Override
    public void init() {
        super.init();
        AdvancedButton scaleB = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.string.setscale", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FMTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.items.string.setscale", (String[])new String[0]) + ":", CharacterFilter.getDoubleCharacterFiler(), 240, this::setScaleCallback)));
        this.rightclickMenu.addContent(scaleB);
        String sLabel = Locals.localize((String)"helper.creator.items.string.setshadow", (String[])new String[0]);
        if (this.getObject().shadow) {
            sLabel = Locals.localize((String)"helper.creator.items.string.setnoshadow", (String[])new String[0]);
        }
        AdvancedButton shadowB = new AdvancedButton(0, 0, 0, 16, sLabel, true, press -> {
            if (this.getObject().shadow) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.string.setshadow", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().shadow = false;
            } else {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"helper.creator.items.string.setnoshadow", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().shadow = true;
            }
        });
        this.rightclickMenu.addContent(shadowB);
        FMContextMenu alignmentMenu = new FMContextMenu();
        alignmentMenu.setAutoclose(true);
        this.rightclickMenu.addChild(alignmentMenu);
        String al = Locals.localize((String)"helper.creator.items.string.alignment.left", (String[])new String[0]);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.LEFT) {
            al = "\u00a7a" + al;
        }
        this.alignmentLeftBtn = new AdvancedButton(0, 0, 0, 0, al, true, press -> {
            this.getObject().alignment = CustomizationItemBase.Alignment.LEFT;
            ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"helper.creator.items.string.alignment.left", (String[])new String[0]));
            this.alignmentRightBtn.setMessage(Locals.localize((String)"helper.creator.items.string.alignment.right", (String[])new String[0]));
            this.alignmentCenteredBtn.setMessage(Locals.localize((String)"helper.creator.items.string.alignment.centered", (String[])new String[0]));
        });
        alignmentMenu.addContent(this.alignmentLeftBtn);
        String ar = Locals.localize((String)"helper.creator.items.string.alignment.right", (String[])new String[0]);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.RIGHT) {
            ar = "\u00a7a" + ar;
        }
        this.alignmentRightBtn = new AdvancedButton(0, 0, 0, 0, ar, true, press -> {
            this.getObject().alignment = CustomizationItemBase.Alignment.RIGHT;
            ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"helper.creator.items.string.alignment.right", (String[])new String[0]));
            this.alignmentLeftBtn.setMessage(Locals.localize((String)"helper.creator.items.string.alignment.left", (String[])new String[0]));
            this.alignmentCenteredBtn.setMessage(Locals.localize((String)"helper.creator.items.string.alignment.centered", (String[])new String[0]));
        });
        alignmentMenu.addContent(this.alignmentRightBtn);
        String ac = Locals.localize((String)"helper.creator.items.string.alignment.centered", (String[])new String[0]);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.CENTERED) {
            ac = "\u00a7a" + ac;
        }
        this.alignmentCenteredBtn = new AdvancedButton(0, 0, 0, 0, ac, true, press -> {
            this.getObject().alignment = CustomizationItemBase.Alignment.CENTERED;
            ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"helper.creator.items.string.alignment.centered", (String[])new String[0]));
            this.alignmentRightBtn.setMessage(Locals.localize((String)"helper.creator.items.string.alignment.right", (String[])new String[0]));
            this.alignmentLeftBtn.setMessage(Locals.localize((String)"helper.creator.items.string.alignment.left", (String[])new String[0]));
        });
        alignmentMenu.addContent(this.alignmentCenteredBtn);
        AdvancedButton alignmentBtn = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"helper.creator.items.string.alignment", (String[])new String[0]), true, press -> {
            alignmentMenu.setParentButton((AdvancedButton)press);
            alignmentMenu.openMenuAt(0, press.field_230691_m_);
        });
        alignmentBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.creator.items.string.alignment.desc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(alignmentBtn);
        AdvancedButton editTextB = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"helper.creator.items.string.edit", (String[])new String[0]), true, press -> {
            DynamicValueInputPopup i = new DynamicValueInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"helper.creator.items.string.edit", (String[])new String[0]) + ":", null, 240, this::setTextCallback);
            i.setText(StringUtils.convertFormatCodes((String)this.object.value, (String)"\u00a7", (String)"&"));
            PopupHandler.displayPopup((Popup)i);
        });
        this.rightclickMenu.addContent(editTextB);
    }

    @Override
    protected void renderBorder(MatrixStack matrix, int mouseX, int mouseY) {
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)this.getStringPosY(), (int)(this.getStringPosX() + this.object.getWidth()), (int)(this.getStringPosY() + 1), (int)Color.BLUE.getRGB());
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)(this.getStringPosY() + this.object.getHeight()), (int)(this.getStringPosX() + this.object.getWidth() + 1), (int)(this.getStringPosY() + this.object.getHeight() + 1), (int)Color.BLUE.getRGB());
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)this.getStringPosY(), (int)(this.getStringPosX() + 1), (int)(this.getStringPosY() + this.object.getHeight()), (int)Color.BLUE.getRGB());
        LayoutString.func_238467_a_((MatrixStack)matrix, (int)(this.getStringPosX() + this.object.getWidth()), (int)this.getStringPosY(), (int)(this.getStringPosX() + this.object.getWidth() + 1), (int)(this.getStringPosY() + this.object.getHeight()), (int)Color.BLUE.getRGB());
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderUtils.setScale((MatrixStack)matrix, (float)0.5f);
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.border.orientation", (String[])new String[0]) + ": " + this.object.orientation, (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 44), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.string.border.scale", (String[])new String[0]) + ": " + this.getStringScale(), (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 35), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.string.border.alignment", (String[])new String[0]) + ": " + this.getObject().alignment.key, (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 26), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.border.posx", (String[])new String[0]) + ": " + this.getStringPosX(), (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 17), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.border.width", (String[])new String[0]) + ": " + this.object.getWidth(), (float)(this.getStringPosX() * 2), (float)(this.getStringPosY() * 2 - 8), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.border.posy", (String[])new String[0]) + ": " + this.getStringPosY(), (float)((this.getStringPosX() + this.object.getWidth()) * 2 + 3), (float)((this.getStringPosY() + this.object.getHeight()) * 2 - 14), Color.WHITE.getRGB());
        font.func_238421_b_(matrix, Locals.localize((String)"helper.creator.items.border.height", (String[])new String[0]) + ": " + this.object.getHeight(), (float)((this.getStringPosX() + this.object.getWidth()) * 2 + 3), (float)((this.getStringPosY() + this.object.getHeight()) * 2 - 5), Color.WHITE.getRGB());
        RenderUtils.postScale((MatrixStack)matrix);
    }

    @Override
    protected void renderHighlightBorder(MatrixStack matrix) {
        Color c = new Color(0, 200, 255, 255);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)this.getStringPosY(), (int)(this.getStringPosX() + this.object.getWidth()), (int)(this.getStringPosY() + 1), (int)c.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)(this.getStringPosY() + this.object.getHeight()), (int)(this.getStringPosX() + this.object.getWidth() + 1), (int)(this.getStringPosY() + this.object.getHeight() + 1), (int)c.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)this.getStringPosX(), (int)this.getStringPosY(), (int)(this.getStringPosX() + 1), (int)(this.getStringPosY() + this.object.getHeight()), (int)c.getRGB());
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(this.getStringPosX() + this.object.getWidth()), (int)this.getStringPosY(), (int)(this.getStringPosX() + this.object.getWidth() + 1), (int)(this.getStringPosY() + this.object.getHeight()), (int)c.getRGB());
    }

    private int getStringPosX() {
        return (int)((float)this.object.getPosX(this.handler) * this.getStringScale());
    }

    private int getStringPosY() {
        return (int)((float)this.object.getPosY(this.handler) * this.getStringScale());
    }

    private float getStringScale() {
        return ((StringCustomizationItem)this.object).scale;
    }

    private StringCustomizationItem getObject() {
        return (StringCustomizationItem)this.object;
    }

    @Override
    public boolean isGrabberPressed() {
        return false;
    }

    @Override
    public int getActiveResizeGrabber() {
        return -1;
    }

    @Override
    protected void setOrientation(String pos) {
        super.setOrientation(pos);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.CENTERED) {
            if (this.object.orientation.endsWith("-right")) {
                this.object.posX += this.object.getWidth();
            }
            if (this.object.orientation.endsWith("-centered")) {
                this.object.posX += this.object.getWidth() / 2;
            }
        } else if (this.getObject().alignment == CustomizationItemBase.Alignment.RIGHT) {
            if (this.object.orientation.endsWith("-right")) {
                this.object.posX += this.object.getWidth();
            }
            if (this.object.orientation.endsWith("-left")) {
                this.object.posX += this.object.getWidth();
            }
            if (this.object.orientation.endsWith("-centered")) {
                this.object.posX += this.object.getWidth() / 2;
            }
        } else if (this.getObject().alignment == CustomizationItemBase.Alignment.LEFT && this.object.orientation.endsWith("-centered")) {
            this.object.posX += this.object.getWidth() / 2;
        }
    }

    public void setScale(float scale) {
        if (this.getObject().scale != scale) {
            this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        }
        ((StringCustomizationItem)this.object).scale = scale;
        this.setWidth((int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(this.object.value) * scale));
        this.setHeight((int)(7.0f * scale));
    }

    public void setText(String text) {
        if (!this.getObject().valueRaw.equals(text)) {
            this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        }
        this.getObject().valueRaw = text;
        this.getObject().value = text;
        this.setScale(this.getStringScale());
    }

    private void setTextCallback(String text) {
        if (text == null) {
            return;
        }
        if (text.length() > 0) {
            this.setText(StringUtils.convertFormatCodes((String)text, (String)"&", (String)"\u00a7"));
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.texttooshort.title", (String[])new String[0]), "", Locals.localize((String)"helper.creator.texttooshort.desc", (String[])new String[0]), "", "", "", "");
        }
    }

    private void setScaleCallback(String scale) {
        if (scale == null) {
            return;
        }
        if (MathUtils.isFloat((String)scale)) {
            this.setScale(Float.valueOf(scale).floatValue());
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"helper.creator.items.string.scale.invalidvalue.title", (String[])new String[0]), "", Locals.localize((String)"helper.creator.items.string.scale.invalidvalue.desc", (String[])new String[0]), "", "", "", "", "");
        }
    }

    @Override
    protected void updateHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.getStringPosX() && mouseX <= this.getStringPosX() + this.object.getWidth() && mouseY >= this.getStringPosY() && mouseY <= this.getStringPosY() + this.object.getHeight();
    }

    @Override
    public List<PropertiesSection> getProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        PropertiesSection p1 = new PropertiesSection("customization");
        p1.addEntry("action", "addtext");
        p1.addEntry("actionid", this.object.getActionId());
        if (this.object.delayAppearance) {
            p1.addEntry("delayappearance", "true");
            p1.addEntry("delayappearanceeverytime", "" + this.object.delayAppearanceEverytime);
            p1.addEntry("delayappearanceseconds", "" + this.object.delayAppearanceSec);
            if (this.object.fadeIn) {
                p1.addEntry("fadein", "true");
                p1.addEntry("fadeinspeed", "" + this.object.fadeInSpeed);
            }
        }
        p1.addEntry("value", this.object.value);
        p1.addEntry("x", "" + this.object.posX);
        p1.addEntry("y", "" + this.object.posY);
        p1.addEntry("orientation", this.object.orientation);
        if (this.object.orientation.equals("element") && this.object.orientationElementIdentifier != null) {
            p1.addEntry("orientation_element", this.object.orientationElementIdentifier);
        }
        p1.addEntry("scale", "" + this.getObject().scale);
        p1.addEntry("shadow", "" + this.getObject().shadow);
        p1.addEntry("alignment", "" + this.getObject().alignment.key);
        this.addVisibilityPropertiesTo(p1);
        l.add(p1);
        return l;
    }
}

