/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;

public class AutoScalingPopup
extends FMPopup {
    private LayoutEditorScreen parent;
    private AdvancedButton cancelButton;
    private AdvancedButton doneButton;
    private AdvancedTextField widthTextField;
    private AdvancedTextField heightTextField;
    protected Consumer<Boolean> callback = null;

    public AutoScalingPopup(LayoutEditorScreen parent, @Nullable Consumer<Boolean> callback) {
        super(240);
        this.callback = callback;
        this.parent = parent;
        this.cancelButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> this.onCancelButtonPressed());
        this.addButton(this.cancelButton);
        this.doneButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.onDoneButtonPressed());
        this.addButton(this.doneButton);
        this.widthTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        this.widthTextField.func_146180_a("" + Minecraft.func_71410_x().func_228018_at_().func_198105_m());
        this.heightTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        this.heightTextField.func_146180_a("" + Minecraft.func_71410_x().func_228018_at_().func_198083_n());
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    public void render(MatrixStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        float partial = Minecraft.func_71410_x().func_184121_ak();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int screenCenterX = renderIn.field_230708_k_ / 2;
        int screenCenterY = renderIn.field_230709_l_ / 2;
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line1", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 90), (int)-1);
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line2", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 80), (int)-1);
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line3", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 70), (int)-1);
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"general.width", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 50), (int)-1);
        this.widthTextField.field_230690_l_ = screenCenterX - this.widthTextField.func_230998_h_() / 2;
        this.widthTextField.field_230691_m_ = screenCenterY - 35;
        this.widthTextField.func_230430_a_(matrix, mouseX, mouseY, partial);
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)Locals.localize((String)"general.height", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 5), (int)-1);
        this.heightTextField.field_230690_l_ = screenCenterX - this.heightTextField.func_230998_h_() / 2;
        this.heightTextField.field_230691_m_ = screenCenterY + 10;
        this.heightTextField.func_230430_a_(matrix, mouseX, mouseY, partial);
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentwidth", (String[])new String[0]) + ": " + Minecraft.func_71410_x().func_228018_at_().func_198105_m()), (int)screenCenterX, (int)(screenCenterY + 45), (int)-1);
        AutoScalingPopup.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentheight", (String[])new String[0]) + ": " + Minecraft.func_71410_x().func_228018_at_().func_198083_n()), (int)screenCenterX, (int)(screenCenterY + 55), (int)-1);
        this.doneButton.field_230690_l_ = screenCenterX - this.doneButton.func_230998_h_() - 5;
        this.doneButton.field_230691_m_ = screenCenterY + 80;
        this.cancelButton.field_230690_l_ = screenCenterX + 5;
        this.cancelButton.field_230691_m_ = screenCenterY + 80;
        this.renderButtons(matrix, mouseX, mouseY);
    }

    protected void onDoneButtonPressed() {
        try {
            if (MathUtils.isInteger((String)this.widthTextField.func_146179_b()) && MathUtils.isInteger((String)this.heightTextField.func_146179_b())) {
                int w = Integer.parseInt(this.widthTextField.func_146179_b());
                int h = Integer.parseInt(this.heightTextField.func_146179_b());
                if (w > 0 && h > 0) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    this.parent.autoScalingWidth = w;
                    this.parent.autoScalingHeight = h;
                    this.answerCallback(true);
                } else {
                    this.answerCallback(false);
                    LayoutEditorScreen.displayNotification(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.error", (String[])new String[0]), (String)"%n%"));
                }
            } else {
                this.answerCallback(false);
                LayoutEditorScreen.displayNotification(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.error", (String[])new String[0]), (String)"%n%"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayed(false);
    }

    protected void onCancelButtonPressed() {
        this.answerCallback(false);
        this.setDisplayed(false);
    }

    protected void answerCallback(boolean b) {
        if (this.callback != null) {
            this.callback.accept(b);
        }
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed() && this.doneButton != null && this.doneButton.field_230694_p_) {
            this.onDoneButtonPressed();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            this.onCancelButtonPressed();
        }
    }
}

