/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.RenderGuiListBackgroundEvent;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.mainwindow.MainWindowHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonMimeHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.konkrete.file.FileUtils;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuCustomizationEvents {
    private static final Logger LOGGER = LogManager.getLogger((String)"fanvymenu/MenuCustomizationEvents");
    private boolean idle = false;
    private boolean iconSetAfterFullscreen = false;
    private boolean scaleChecked = false;
    private boolean resumeWorldMusic = false;
    protected Screen lastScreen = null;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInitPrePre(GuiScreenEvent.InitGuiEvent.Pre e) {
        if (!ButtonCache.isCaching() && MenuCustomization.isValidScreen(e.getGui())) {
            Screen current = Minecraft.func_71410_x().field_71462_r;
            MenuCustomization.isNewMenu = current != null ? (this.lastScreen != null ? !this.lastScreen.getClass().getName().equals(current.getClass().getName()) : true) : true;
            this.lastScreen = current;
            if (MenuCustomization.isNewMenu) {
                ButtonMimeHandler.clearCache();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMenuReloaded(MenuReloadedEvent e) {
        ButtonMimeHandler.clearCache();
        MenuCustomization.isNewMenu = true;
        this.lastScreen = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSoftReload(SoftMenuReloadEvent e) {
        ButtonMimeHandler.clearCache();
        MenuCustomization.isNewMenu = true;
        this.lastScreen = null;
    }

    @SubscribeEvent
    public void onInitPre(GuiScreenEvent.InitGuiEvent.Pre e) {
        MenuCustomization.isCurrentScrollable = false;
        if (MenuCustomization.isValidScreen(e.getGui()) && !LayoutEditorScreen.isActive) {
            this.idle = false;
        }
        if (MenuCustomization.isValidScreen(e.getGui()) && !MenuCustomization.isMenuCustomizable(e.getGui()) && !(e.getGui() instanceof LayoutEditorScreen)) {
            MenuCustomization.stopSounds();
            MenuCustomization.resetSounds();
        }
        if (Minecraft.func_71410_x().field_71441_e == null && !((Boolean)FancyMenu.config.getOrDefault("playmenumusic", (Object)true)).booleanValue()) {
            Minecraft.func_71410_x().func_181535_r().func_209200_a();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71462_r == null) {
            this.lastScreen = null;
        }
        if (Minecraft.func_71410_x().field_71462_r == null && !this.idle) {
            MenuCustomization.stopSounds();
            MenuCustomization.resetSounds();
            this.idle = true;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71462_r == null && this.resumeWorldMusic) {
            Minecraft.func_71410_x().func_147118_V().func_147687_e();
            this.resumeWorldMusic = false;
        }
        if (Minecraft.func_71410_x().func_228018_at_().func_198113_j()) {
            this.iconSetAfterFullscreen = false;
        } else if (!this.iconSetAfterFullscreen) {
            MainWindowHandler.updateWindowIcon();
            this.iconSetAfterFullscreen = true;
        }
        if (!this.scaleChecked && Minecraft.func_71410_x().field_71474_y != null) {
            this.scaleChecked = true;
            int scale = (Integer)FancyMenu.config.getOrDefault("defaultguiscale", (Object)-1);
            if (scale != -1 && scale != 0) {
                File f = FancyMenu.INSTANCE_DATA_DIR;
                if (!f.exists()) {
                    f.mkdirs();
                }
                File f2 = new File(f.getPath() + "/default_scale_set.fm");
                File f3 = new File("mods/fancymenu/defaultscaleset.fancymenu");
                if (!f2.exists() && !f3.exists()) {
                    try {
                        f2.createNewFile();
                        FileUtils.writeTextToFile((File)f2, (boolean)false, (String[])new String[]{"you're not supposed to be here! shoo!"});
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    LOGGER.info("########################### FANCYMENU: SETTING DEFAULT GUI SCALE!");
                    Minecraft.func_71410_x().field_71474_y.field_74335_Z = scale;
                    Minecraft.func_71410_x().field_71474_y.func_74303_b();
                    Minecraft.func_71410_x().func_213226_a();
                }
            }
        }
        if (Minecraft.func_71410_x().field_71462_r == null) {
            MenuCustomization.isCurrentScrollable = false;
        }
    }

    @SubscribeEvent
    public void onRenderListBackground(RenderGuiListBackgroundEvent.Pre e) {
        MenuCustomization.isCurrentScrollable = true;
    }
}

