/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationEvents;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomizationProperties;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.SetupSharingEngine;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerEvents;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.DummyCoreMainHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.MainMenuHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.MoreRefinedStorageMainHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.PauseScreenHandler;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.WorldLoadingScreenHandler;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.sound.SoundHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MenuCustomization {
    private static PropertiesSet customizableMenus;
    private static boolean initDone;
    private static List<String> sounds;
    public static final File CUSTOMIZABLE_MENUS_FILE;
    protected static boolean isCurrentScrollable;
    protected static boolean isNewMenu;
    protected static MenuCustomizationEvents eventsInstance;
    public static boolean isLoadingScreen;

    public static void init() {
        if (!initDone) {
            MinecraftForge.EVENT_BUS.register((Object)eventsInstance);
            MenuHandlerRegistry.registerHandler(new MainMenuHandler());
            MenuHandlerRegistry.registerHandler(new MoreRefinedStorageMainHandler());
            MenuHandlerRegistry.registerHandler(new DummyCoreMainHandler());
            MenuHandlerRegistry.registerHandler(new WorldLoadingScreenHandler());
            MenuHandlerRegistry.registerHandler(new PauseScreenHandler());
            MinecraftForge.EVENT_BUS.register((Object)new MenuHandlerEvents());
            CustomizationHelper.init();
            MinecraftForge.EVENT_BUS.register((Object)new ButtonCache());
            MenuCustomizationProperties.loadProperties();
            MenuCustomization.updateCustomizeableMenuCache();
            initDone = true;
        }
    }

    public static void updateCustomizeableMenuCache() {
        try {
            PropertiesSet s;
            if (!CUSTOMIZABLE_MENUS_FILE.exists()) {
                CUSTOMIZABLE_MENUS_FILE.createNewFile();
                PropertiesSerializer.writeProperties((PropertiesSet)new PropertiesSet("customizablemenus"), (String)CUSTOMIZABLE_MENUS_FILE.getPath());
            }
            if ((s = PropertiesSerializer.getProperties((String)CUSTOMIZABLE_MENUS_FILE.getPath())) == null) {
                PropertiesSerializer.writeProperties((PropertiesSet)new PropertiesSet("customizablemenus"), (String)CUSTOMIZABLE_MENUS_FILE.getPath());
                s = PropertiesSerializer.getProperties((String)CUSTOMIZABLE_MENUS_FILE.getPath());
            }
            PropertiesSet s2 = new PropertiesSet("customizablemenus");
            for (PropertiesSection sec : s.getProperties()) {
                String identifier = null;
                try {
                    if (sec.getSectionType().equals("net.mehvahdjukaar.supplementaries.compat.configured.CustomConfigScreen")) {
                        identifier = sec.getSectionType();
                    } else if (sec.getSectionType() != null && sec.getSectionType().length() > 5) {
                        Class.forName(sec.getSectionType());
                        identifier = sec.getSectionType();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (identifier == null) {
                    identifier = MenuCustomization.getValidMenuIdentifierFor(sec.getSectionType());
                }
                s2.addProperties(new PropertiesSection(identifier));
            }
            customizableMenus = s2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void syncCustomizeableMenusToFile() {
        PropertiesSerializer.writeProperties((PropertiesSet)customizableMenus, (String)CUSTOMIZABLE_MENUS_FILE.getPath());
    }

    public static void enableCustomizationForMenu(Screen menu) {
        String identifier;
        if (menu != null && !(menu instanceof CustomGuiBase) && (identifier = menu.getClass().getName()) != null && customizableMenus != null) {
            PropertiesSection sec = new PropertiesSection(identifier);
            customizableMenus.addProperties(sec);
            MenuCustomization.syncCustomizeableMenusToFile();
        }
    }

    public static void disableCustomizationForMenu(Screen menu) {
        String identifier;
        if (menu != null && !(menu instanceof CustomGuiBase) && (identifier = menu.getClass().getName()) != null && customizableMenus != null) {
            ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
            for (PropertiesSection sec : customizableMenus.getProperties()) {
                if (sec.getSectionType().equals(identifier)) continue;
                l.add(sec);
            }
            customizableMenus = new PropertiesSet("customizablemenus");
            for (PropertiesSection sec : l) {
                customizableMenus.addProperties(sec);
            }
            MenuCustomization.syncCustomizeableMenusToFile();
        }
    }

    public static boolean isMenuCustomizable(Screen menu) {
        if (menu != null) {
            List s;
            if (menu instanceof CustomGuiBase) {
                return true;
            }
            String identifier = menu.getClass().getName();
            if (identifier != null && customizableMenus != null && (s = customizableMenus.getPropertiesOfType(identifier)) != null && !s.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static String getValidMenuIdentifierFor(String identifier) {
        SetupSharingEngine.MenuIdentifierDatabase db = SetupSharingEngine.getIdentifierDatabase();
        try {
            Class.forName(identifier);
            return identifier;
        }
        catch (Exception exception) {
            String s;
            if (db != null && (s = db.findValidIdentifierFor(identifier)) != null) {
                return s;
            }
            return identifier;
        }
    }

    public static void reload() {
        if (initDone) {
            MenuCustomization.updateCustomizeableMenuCache();
            MenuCustomizationProperties.loadProperties();
        }
    }

    public static boolean isValidScreen(Screen screen) {
        if (screen == null) {
            return false;
        }
        return Minecraft.func_71410_x().field_71462_r == screen;
    }

    public static void registerSound(String key, String path) {
        if (!sounds.contains(key)) {
            sounds.add(key);
        }
        SoundHandler.registerSound((String)key, (String)path);
    }

    public static void unregisterSound(String key) {
        if (sounds.contains(key)) {
            sounds.remove(key);
        }
        SoundHandler.unregisterSound((String)key);
    }

    public static void stopSounds() {
        for (String s : sounds) {
            SoundHandler.stopSound((String)s);
        }
    }

    public static void resetSounds() {
        for (String s : sounds) {
            SoundHandler.resetSound((String)s);
        }
    }

    public static boolean isSoundRegistered(String key) {
        return sounds.contains(key);
    }

    public static List<String> getSounds() {
        return sounds;
    }

    public static boolean isCurrentMenuScrollable() {
        return isCurrentScrollable;
    }

    public static String generateRandomActionId() {
        long ms = System.currentTimeMillis();
        String s = UUID.randomUUID().toString();
        return s + ms;
    }

    public static boolean isNewMenu() {
        return isNewMenu;
    }

    public static void setIsNewMenu(boolean b) {
        isNewMenu = b;
        MenuCustomization.eventsInstance.lastScreen = null;
    }

    public static void reloadCurrentMenu() {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s != null && MenuCustomization.isMenuCustomizable(s)) {
            MenuCustomization.setIsNewMenu(true);
            SoftMenuReloadEvent e = new SoftMenuReloadEvent(s);
            MinecraftForge.EVENT_BUS.post((Event)e);
            Minecraft.func_71410_x().func_147108_a(s);
        }
    }

    public static void enableLayout(String path) {
        try {
            File f = new File(path);
            String name = FileUtils.generateAvailableFilename((String)FancyMenu.getCustomizationPath().getPath(), (String)Files.getNameWithoutExtension((String)path), (String)"txt");
            FileUtils.copyFile((File)f, (File)new File(FancyMenu.getCustomizationPath().getPath() + "/" + name));
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomizationHelper.reloadSystemAndMenu();
    }

    public static void enableLayout(MenuCustomizationProperties.LayoutProperties layout) {
        if (layout.path != null) {
            MenuCustomization.enableLayout(layout.path);
        }
    }

    public static void disableLayout(String path) {
        try {
            File f = new File(path);
            String disPath = FancyMenu.getCustomizationPath().getPath() + "/.disabled";
            String name = FileUtils.generateAvailableFilename((String)disPath, (String)Files.getNameWithoutExtension((String)path), (String)"txt");
            FileUtils.copyFile((File)f, (File)new File(disPath + "/" + name));
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomizationHelper.reloadSystemAndMenu();
    }

    public static void disableLayout(MenuCustomizationProperties.LayoutProperties layout) {
        if (layout.path != null) {
            MenuCustomization.disableLayout(layout.path);
        }
    }

    static {
        initDone = false;
        sounds = new ArrayList<String>();
        CUSTOMIZABLE_MENUS_FILE = new File("config/fancymenu/customizablemenus.txt");
        isCurrentScrollable = false;
        isNewMenu = true;
        eventsInstance = new MenuCustomizationEvents();
        isLoadingScreen = true;
    }
}

