/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.placeholder;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.placeholder.PlaceholderTextContainer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlaceholderTextRegistry {
    private static Map<String, PlaceholderTextContainer> placeholders = new LinkedHashMap<String, PlaceholderTextContainer>();

    public static void registerPlaceholder(PlaceholderTextContainer placeholder) {
        if (placeholder != null) {
            if (placeholder.getIdentifier() != null) {
                if (placeholders.containsKey(placeholder.getIdentifier())) {
                    FancyMenu.LOGGER.warn("[FANCYMENU] WARNING! A placeholder text with the identifier '" + placeholder.getIdentifier() + "' is already registered! Overriding item!");
                }
                placeholders.put(placeholder.getIdentifier(), placeholder);
            } else {
                FancyMenu.LOGGER.error("[FANCYMENU] ERROR! Placeholder identifier cannot be null for PlaceholderTextContainers!");
            }
        }
    }

    public static void unregisterPlaceholder(String placeholderIdentifier) {
        placeholders.remove(placeholderIdentifier);
    }

    public static List<PlaceholderTextContainer> getPlaceholders() {
        ArrayList<PlaceholderTextContainer> l = new ArrayList<PlaceholderTextContainer>();
        l.addAll(placeholders.values());
        return l;
    }

    public static PlaceholderTextContainer getPlaceholder(String placeholderIdentifier) {
        return placeholders.get(placeholderIdentifier);
    }
}

