/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.buttonaction;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ButtonActionRegistry {
    protected static Map<String, ButtonActionContainer> actions = new LinkedHashMap<String, ButtonActionContainer>();

    public static void registerButtonAction(ButtonActionContainer action) {
        if (action != null) {
            if (action.getIdentifier() != null) {
                if (actions.containsKey(action.getIdentifier())) {
                    FancyMenu.LOGGER.warn("[FANCYMENU] WARNING! A button action with the identifier '" + action.getIdentifier() + "' is already registered! Overriding action!");
                }
                actions.put(action.getIdentifier(), action);
            } else {
                FancyMenu.LOGGER.error("[FANCYMENU] ERROR! Action identifier cannot be null for ButtonActionContainers!");
            }
        }
    }

    public static void unregisterButtonAction(String actionIdentifier) {
        actions.remove(actionIdentifier);
    }

    public static List<ButtonActionContainer> getActions() {
        ArrayList<ButtonActionContainer> l = new ArrayList<ButtonActionContainer>();
        actions.forEach((key, value) -> l.add((ButtonActionContainer)value));
        return l;
    }

    public static ButtonActionContainer getAction(String actionIdentifier) {
        return actions.get(actionIdentifier);
    }

    public static ButtonActionContainer getActionByName(String actionName) {
        for (ButtonActionContainer c : actions.values()) {
            if (c.getAction() == null || !c.getAction().equals(actionName)) continue;
            return c;
        }
        return null;
    }
}

