/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.world.gen.feature.BigMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class SplitBigMushroomFeature
extends BigMushroomFeature {
    public SplitBigMushroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    protected abstract int getSize(Random var1);

    protected abstract int getCapRadius(Random var1);

    protected abstract int getSmallSize(Random var1);

    protected abstract int getSmallCapRadius(Random var1);

    protected abstract boolean canPlaceCap(IWorld var1, BlockPos var2, BigMushroomFeatureConfig var3, int var4, BlockPos.Mutable var5);

    protected abstract void placeCap(IWorld var1, Random var2, BlockPos var3, BigMushroomFeatureConfig var4, int var5, BlockPos.Mutable var6);

    protected boolean canPlaceCaps(IWorld level, BigMushroomFeatureConfig config, Pair<BlockPos, Integer>[] capPairs, BlockPos.Mutable mutableBlockPos) {
        AtomicBoolean canPlaceCaps = new AtomicBoolean(true);
        Arrays.stream(capPairs).forEach(pair -> canPlaceCaps.set(canPlaceCaps.get() && this.canPlaceCap(level, (BlockPos)pair.getLeft(), config, (Integer)pair.getRight(), mutableBlockPos)));
        return canPlaceCaps.get();
    }

    protected void placeCaps(IWorld level, Random random, BigMushroomFeatureConfig config, Pair<BlockPos, Integer>[] capPairs, BlockPos.Mutable mutableBlockPos) {
        Arrays.stream(capPairs).forEach(pair -> this.placeCap(level, random, (BlockPos)pair.getLeft(), config, (Integer)pair.getRight(), mutableBlockPos));
    }

    protected Direction[] getDirections(Random random) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        while (directions.size() < 2) {
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
            if (directions.contains(direction)) continue;
            directions.add(direction);
        }
        if (((Direction)directions.get(1)).func_176734_d() != directions.get(0) && random.nextInt(12) == 0) {
            directions.add(((Direction)directions.get(1)).func_176734_d());
        }
        return directions.toArray(new Direction[0]);
    }

    protected Triple<Direction, Integer, Integer>[] getTrunkTriples(Direction[] directions, Random random) {
        Triple[] triples = new Triple[directions.length];
        for (int i = 0; i < directions.length; ++i) {
            triples[i] = Triple.of((Object)directions[i], (Object)(i == 0 ? this.getSize(random) : this.getSmallSize(random)), (Object)this.getDistanceToCenter(random));
        }
        return triples;
    }

    protected Pair<BlockPos, Integer>[] getCapPairs(BlockPos mushroomPos, Triple<Direction, Integer, Integer>[] trunkTriples, Random random) {
        Pair[] pairs = new Pair[trunkTriples.length];
        for (int i = 0; i < trunkTriples.length; ++i) {
            pairs[i] = Pair.of((Object)this.getCapCenter(mushroomPos, trunkTriples[i]), (Object)(i == 0 ? this.getCapRadius(random) : this.getSmallCapRadius(random)));
        }
        return pairs;
    }

    protected int getDistanceToCenter(Random random) {
        return 2 + random.nextInt(1);
    }

    protected BlockPos getCapCenter(BlockPos mushroomPos, Triple<Direction, Integer, Integer> trunkTriple) {
        return new BlockPos.Mutable().func_189533_g((Vector3i)mushroomPos).func_189534_c(Direction.UP, ((Integer)trunkTriple.getMiddle()).intValue()).func_189534_c((Direction)trunkTriple.getLeft(), ((Integer)trunkTriple.getRight()).intValue()).func_185334_h();
    }

    protected boolean canPlaceTrunks(IWorld level, BlockPos blockPos, BigMushroomFeatureConfig config, Triple<Direction, Integer, Integer>[] directions, BlockPos.Mutable mutableBlockPos) {
        AtomicBoolean canPlaceTrunks = new AtomicBoolean(true);
        Arrays.stream(directions).forEach(triple -> canPlaceTrunks.set(canPlaceTrunks.get() && this.canPlaceTrunk(level, blockPos, config, (Direction)triple.getLeft(), (Integer)triple.getMiddle(), (Integer)triple.getRight(), mutableBlockPos)));
        return canPlaceTrunks.get();
    }

    protected boolean canPlaceTrunk(IWorld level, BlockPos blockPos, BigMushroomFeatureConfig config, Direction direction, int size, int distanceToCenter, BlockPos.Mutable mutableBlockPos) {
        mutableBlockPos.func_189533_g((Vector3i)blockPos);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                if (i <= distanceToCenter) {
                    mutableBlockPos.func_189536_c(direction);
                }
                mutableBlockPos.func_189536_c(Direction.UP);
            }
            if (level.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLogs((IWorldReader)level, (BlockPos)mutableBlockPos)) continue;
            return false;
        }
        return true;
    }

    protected void placeTrunks(IWorld level, Random random, BlockPos blockPos, BigMushroomFeatureConfig config, Triple<Direction, Integer, Integer>[] directions, BlockPos.Mutable mutableBlockPos) {
        Arrays.stream(directions).forEach(triple -> this.placeTrunk(level, random, blockPos, config, (Direction)triple.getLeft(), (Integer)triple.getMiddle(), (Integer)triple.getRight(), mutableBlockPos));
    }

    protected void placeTrunk(IWorld level, Random random, BlockPos blockPos, BigMushroomFeatureConfig config, Direction direction, int size, int distanceToCenter, BlockPos.Mutable mutableBlockPos) {
        mutableBlockPos.func_189533_g((Vector3i)blockPos);
        for (int i = 0; i < size; ++i) {
            boolean down;
            boolean up = i == 0;
            boolean bl = down = i == distanceToCenter;
            if (i > 0) {
                if (i <= distanceToCenter) {
                    up = true;
                    down = true;
                    mutableBlockPos.func_189536_c(direction);
                }
                mutableBlockPos.func_189536_c(Direction.UP);
            }
            this.placeTrunkBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos, up, down);
        }
    }

    public boolean place(@Nonnull ISeedReader level, @Nullable ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BigMushroomFeatureConfig config) {
        Direction[] directions = this.getDirections(rand);
        Triple<Direction, Integer, Integer>[] trunkTriples = this.getTrunkTriples(directions, rand);
        Pair<BlockPos, Integer>[] capPairs = this.getCapPairs(pos, trunkTriples, rand);
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        if (this.isInWorldBounds((IWorld)level, pos, (Integer)trunkTriples[0].getMiddle()) && this.hasValidGround((IWorld)level, pos) && this.canPlaceTrunks((IWorld)level, pos, config, trunkTriples, mutableBlockPos) && this.canPlaceCaps((IWorld)level, config, capPairs, mutableBlockPos)) {
            this.placeTrunks((IWorld)level, rand, pos, config, trunkTriples, mutableBlockPos);
            this.placeCaps((IWorld)level, rand, config, capPairs, mutableBlockPos);
            return true;
        }
        return false;
    }
}

