/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.world.gen.feature.BigMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public abstract class SingleBigMushroomFeature
extends BigMushroomFeature {
    public SingleBigMushroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    protected abstract int getCapRadius(Random var1);

    protected int getSize(Random random) {
        int i = random.nextInt(3) + 4;
        if (random.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean canGrow(IWorld world, BlockPos blockPos, int size, int capRadius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        return this.isInWorldBounds(world, blockPos, size) && this.hasValidGround(world, blockPos) && this.canPlaceTrunk(world, blockPos, size, mutableBlockPos, config) && this.canPlaceCap(world, blockPos, size, capRadius, mutableBlockPos, config);
    }

    protected abstract boolean canPlaceCap(IWorld var1, BlockPos var2, int var3, int var4, BlockPos.Mutable var5, BigMushroomFeatureConfig var6);

    protected abstract void placeCap(IWorld var1, Random var2, BlockPos var3, int var4, int var5, BlockPos.Mutable var6, BigMushroomFeatureConfig var7);

    protected boolean canPlaceTrunk(IWorld level, BlockPos blockPos, int size, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        for (int i = 0; i < size; ++i) {
            mutableBlockPos.func_189533_g((Vector3i)blockPos).func_189534_c(Direction.UP, i);
            if (level.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLogs((IWorldReader)level, (BlockPos)mutableBlockPos)) continue;
            return false;
        }
        return true;
    }

    protected void placeTrunk(IWorld level, Random random, BlockPos blockPos, BigMushroomFeatureConfig config, int size, BlockPos.Mutable mutableBlockPos) {
        for (int i = 0; i < size; ++i) {
            mutableBlockPos.func_189533_g((Vector3i)blockPos).func_189534_c(Direction.UP, i);
            this.placeTrunkBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos);
        }
    }

    public boolean place(@Nonnull ISeedReader level, @Nullable ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BigMushroomFeatureConfig config) {
        BlockPos.Mutable mutableBlockPos;
        int capRadius;
        int size = this.getSize(rand);
        if (!this.canGrow((IWorld)level, pos, size, capRadius = this.getCapRadius(rand), mutableBlockPos = new BlockPos.Mutable(), config)) {
            return false;
        }
        this.placeCap((IWorld)level, rand, pos, size, capRadius, mutableBlockPos, config);
        this.placeTrunk((IWorld)level, rand, pos, config, size, mutableBlockPos);
        return true;
    }
}

