/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.world.gen.feature.MegaMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public class MegaRedMushroomFeature
extends MegaMushroomFeature {
    public MegaRedMushroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    @Override
    protected int getCapRadius(Random random) {
        return 4 + random.nextInt(2);
    }

    protected float getCapHeightFactor() {
        return 0.5f;
    }

    @Override
    protected boolean canPlaceCap(IWorld level, BlockPos blockPos, int size, int radius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        int capCenterHeight = (int)((float)size * (1.0f - this.getCapHeightFactor()));
        int capSize = (int)((float)size * this.getCapHeightFactor());
        Cap cap = new Cap((BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(0, capCenterHeight, 0), capSize, radius);
        for (CapPosition capPos : cap.capPositions) {
            if (level.func_180495_p(capPos.blockPos).canBeReplacedByLeaves((IWorldReader)level, capPos.blockPos)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void placeCap(IWorld level, Random random, BlockPos blockPos, int size, int radius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        int capCenterHeight = (int)((float)size * (1.0f - this.getCapHeightFactor()));
        int capSize = (int)((float)size * this.getCapHeightFactor());
        Cap cap = new Cap((BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(0, capCenterHeight, 0), capSize, radius);
        for (CapPosition capPos : cap.capPositions) {
            this.placeCapBlockIfPossible(level, random, config, capPos.blockPos, capPos.west, capPos.east, capPos.north, capPos.south, !cap.hasCapPosition(capPos.blockPos.func_177984_a()));
        }
    }

    private static class CapPosition {
        BlockPos blockPos;
        boolean west;
        boolean east;
        boolean north;
        boolean south;

        private CapPosition(BlockPos pos, boolean west, boolean east, boolean north, boolean south) {
            this.blockPos = pos;
            this.west = west;
            this.east = east;
            this.north = north;
            this.south = south;
        }
    }

    private static class Cap {
        private final BlockPos center;
        private final int size;
        private final float radius;
        private final float a_q;
        private final float b_q;
        private final float c_q;
        private final List<CapPosition> capPositions = new ArrayList<CapPosition>();

        Cap(BlockPos center, int size, int radius) {
            this.center = center;
            this.size = size;
            this.radius = (float)radius + 0.5f;
            this.a_q = radius * radius;
            this.b_q = (float)(size * 2 * (size * 2)) / 4.0f;
            this.c_q = this.a_q;
            this.generateBlockPositions();
        }

        private boolean isInsideEllipsoid(BlockPos pos) {
            float z;
            float y;
            float x = (float)pos.func_177958_n() - 0.5f;
            return x * x / this.a_q + (y = (float)pos.func_177956_o()) * y / this.b_q + (z = (float)pos.func_177952_p() - 0.5f) * z / this.c_q < 1.0f;
        }

        private void generateBlockPositions() {
            for (int y = 0; y <= this.size + 2; ++y) {
                int x = (int)((double)(-this.radius) - 1.5);
                while ((float)x <= this.radius + 2.0f) {
                    int z = (int)((double)(-this.radius) - 1.5);
                    while ((float)z <= this.radius + 2.0f) {
                        BlockPos ellPos = new BlockPos(x, y, z);
                        if (!this.isInsideEllipsoid(ellPos)) {
                            boolean down = this.isInsideEllipsoid(ellPos.func_177977_b());
                            boolean west = this.isInsideEllipsoid(ellPos.func_177976_e());
                            boolean east = this.isInsideEllipsoid(ellPos.func_177974_f());
                            boolean north = this.isInsideEllipsoid(ellPos.func_177978_c());
                            boolean south = this.isInsideEllipsoid(ellPos.func_177968_d());
                            if (down || west || east || north || south) {
                                this.capPositions.add(new CapPosition(this.center.func_177971_a((Vector3i)ellPos), !west, !east, !north, !south));
                            }
                        }
                        ++z;
                    }
                    ++x;
                }
            }
        }

        private boolean hasCapPosition(BlockPos pos) {
            for (CapPosition capPosition : this.capPositions) {
                if (!capPosition.blockPos.equals((Object)pos)) continue;
                return true;
            }
            return false;
        }
    }
}

