/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.world.gen.feature.MegaMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public class MegaBrownMushroomFeature
extends MegaMushroomFeature {
    public MegaBrownMushroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    @Override
    protected int getCapRadius(Random random) {
        return 3 + random.nextInt(2);
    }

    @Override
    protected boolean canPlaceCap(IWorld level, BlockPos blockPos, int size, int capRadius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        for (int x = -capRadius; x <= capRadius + 1; ++x) {
            for (int z = -capRadius; z <= capRadius + 1; ++z) {
                mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(x, size, z);
                if (level.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLeaves((IWorldReader)level, (BlockPos)mutableBlockPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void placeCap(IWorld level, Random random, BlockPos blockPos, int size, int radius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        for (int x = -radius; x <= radius + 1; ++x) {
            for (int z = -radius; z <= radius + 1; ++z) {
                boolean flag5;
                boolean flag = x == -radius;
                boolean flag1 = x == radius + 1;
                boolean flag2 = z == -radius;
                boolean flag3 = z == radius + 1;
                boolean flag4 = flag || flag1;
                boolean bl = flag5 = flag2 || flag3;
                if (flag4 && flag5) continue;
                boolean flag6 = flag || flag5 && x == 1 - radius;
                boolean flag7 = flag1 || flag5 && x == radius;
                boolean flag8 = flag2 || flag4 && z == 1 - radius;
                boolean flag9 = flag3 || flag4 && z == radius;
                this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(x, size, z), flag6, flag7, flag8, flag9);
            }
        }
        for (int i = 0; i < radius * 2; ++i) {
            boolean begin = i == 0;
            boolean end = i == radius * 2 - 1;
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(i - radius + 1, size - 1, -radius - 1), begin, end, true, false);
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(i - radius + 1, size - 1, radius + 2), begin, end, false, true);
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(-radius - 1, size - 1, i - radius + 1), true, false, begin, end);
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(radius + 2, size - 1, i - radius + 1), false, true, begin, end);
        }
        this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(-radius, size - 1, -radius), true, false, true, false);
        this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(-radius, size - 1, radius + 1), true, false, false, true);
        this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(radius + 1, size - 1, -radius), false, true, true, false);
        this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(radius + 1, size - 1, radius + 1), false, true, false, true);
    }
}

