/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.world.gen.feature.SplitBigMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public class BigSlimeFungusFeature
extends SplitBigMushroomFeature {
    public BigSlimeFungusFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    @Override
    protected int getSize(Random random) {
        int size = 7;
        if (random.nextInt(12) == 0) {
            size = 11;
        }
        return size + random.nextInt(2);
    }

    @Override
    protected int getCapRadius(Random random) {
        if (random.nextInt(12) == 0) {
            return 4;
        }
        return 3;
    }

    @Override
    protected int getSmallSize(Random random) {
        return 4 + random.nextInt(1);
    }

    @Override
    protected int getSmallCapRadius(Random random) {
        return 1;
    }

    @Override
    protected boolean canPlaceCap(IWorld level, BlockPos center, BigMushroomFeatureConfig config, int capRadius, BlockPos.Mutable mutableBlockPos) {
        boolean hasCorners = capRadius > 2;
        for (int x = -capRadius; x <= capRadius; ++x) {
            for (int z = -capRadius; z <= capRadius; ++z) {
                if (!(!hasCorners || x != capRadius && x != -capRadius || z != capRadius && z != -capRadius)) continue;
                mutableBlockPos.func_189533_g((Vector3i)center).func_196234_d(x, 0, z);
                if (level.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLeaves((IWorldReader)level, (BlockPos)mutableBlockPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void placeCap(IWorld level, Random random, BlockPos center, BigMushroomFeatureConfig config, int capRadius, BlockPos.Mutable mutableBlockPos) {
        boolean hasCorners = capRadius > 2;
        for (int x = -capRadius; x <= capRadius; ++x) {
            for (int z = -capRadius; z <= capRadius; ++z) {
                if (hasCorners && (x == capRadius || x == -capRadius) && (z == capRadius || z == -capRadius)) continue;
                boolean flag = x == -capRadius || hasCorners && x == -capRadius + 1;
                boolean flag1 = x == capRadius || hasCorners && x == capRadius - 1;
                boolean flag2 = z == -capRadius || hasCorners && z == -capRadius + 1;
                boolean flag3 = z == capRadius || hasCorners && z == capRadius - 1;
                this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)center).func_196234_d(x, 0, z), flag, flag1, flag2, flag3);
            }
        }
    }
}

