/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.MushroomUtils;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public abstract class BigMushroomFeature
extends Feature<BigMushroomFeatureConfig> {
    public BigMushroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    protected boolean isInWorldBounds(IWorld world, BlockPos mushroomPos, int size) {
        int y = mushroomPos.func_177956_o();
        return y >= 1 && y + size + 1 < world.func_234938_ad_();
    }

    protected boolean hasValidGround(IWorld world, BlockPos mushroomPos) {
        return MushroomUtils.isValidMushroomPosition((IWorldReader)world, mushroomPos);
    }

    protected void placeTrunkBlockIfPossible(IWorld level, Random random, BigMushroomFeatureConfig config, BlockPos blockPos) {
        this.placeTrunkBlockIfPossible(level, random, config, blockPos, false, false);
    }

    protected void placeTrunkBlockIfPossible(IWorld level, Random random, BigMushroomFeatureConfig config, BlockPos blockPos, boolean up, boolean down) {
        if (level.func_180495_p(blockPos).canBeReplacedByLogs((IWorldReader)level, blockPos)) {
            this.func_230367_a_((IWorldWriter)level, blockPos, (BlockState)((BlockState)config.field_227273_b_.func_225574_a_(random, blockPos).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(up))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(down)));
        }
    }

    protected void placeCapBlockIfPossible(IWorld level, Random random, BigMushroomFeatureConfig config, BlockPos blockPos, boolean west, boolean east, boolean north, boolean south) {
        this.placeCapBlockIfPossible(level, random, config, blockPos, west, east, north, south, true);
    }

    protected void placeCapBlockIfPossible(IWorld level, Random random, BigMushroomFeatureConfig config, BlockPos blockPos, boolean west, boolean east, boolean north, boolean south, boolean up) {
        if (level.func_180495_p(blockPos).canBeReplacedByLeaves((IWorldReader)level, blockPos)) {
            this.func_230367_a_((IWorldWriter)level, blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.field_227272_a_.func_225574_a_(random, blockPos).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(up)));
        }
    }
}

