/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.world.gen.feature.SingleBigMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public class BigGlowshroomFeature
extends SingleBigMushroomFeature {
    public BigGlowshroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    @Override
    protected int getCapRadius(Random random) {
        if (random.nextInt(12) == 0) {
            return 3;
        }
        return 2;
    }

    @Override
    protected boolean canPlaceCap(IWorld level, BlockPos blockPos, int size, int capRadius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        for (int x = -capRadius; x <= capRadius; ++x) {
            for (int z = -capRadius; z <= capRadius; ++z) {
                mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(x, size, z);
                if (!level.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLeaves((IWorldReader)level, (BlockPos)mutableBlockPos)) {
                    return false;
                }
                mutableBlockPos.func_189534_c(Direction.DOWN, 1);
                if (level.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLeaves((IWorldReader)level, (BlockPos)mutableBlockPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void placeCap(IWorld level, Random random, BlockPos blockPos, int size, int capRadius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        int topRadius = capRadius - 1;
        for (int x = -topRadius; x <= topRadius; ++x) {
            for (int z = -topRadius; z <= topRadius; ++z) {
                boolean flag = x == -topRadius;
                boolean flag1 = x == topRadius;
                boolean flag2 = z == -topRadius;
                boolean flag3 = z == topRadius;
                this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(x, size, z), flag, flag1, flag2, flag3);
            }
        }
        int sideLength = topRadius * 2 + 1;
        for (int i = 0; i < sideLength; ++i) {
            boolean begin = i == 0;
            boolean end = i == sideLength - 1;
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(i - capRadius + 1, size - 1, -capRadius), begin, end, true, false);
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(i - capRadius + 1, size - 1, capRadius), begin, end, false, true);
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(-capRadius, size - 1, i - capRadius + 1), true, false, begin, end);
            this.placeCapBlockIfPossible(level, random, config, (BlockPos)mutableBlockPos.func_189533_g((Vector3i)blockPos).func_196234_d(capRadius, size - 1, i - capRadius + 1), false, true, begin, end);
        }
    }
}

