/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.tileentity;

import cech12.extendedmushrooms.api.recipe.ExtendedMushroomsRecipeTypes;
import cech12.extendedmushrooms.api.recipe.FairyRingMode;
import cech12.extendedmushrooms.api.recipe.FairyRingRecipe;
import cech12.extendedmushrooms.api.tileentity.ExtendedMushroomsTileEntities;
import cech12.extendedmushrooms.block.FairyRingBlock;
import cech12.extendedmushrooms.init.ModParticles;
import cech12.extendedmushrooms.init.ModSounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FairyRingTileEntity
extends TileEntity
implements IInventory,
ITickableTileEntity {
    public static final Vector3d CENTER_TRANSLATION_VECTOR = new Vector3d(1.0, 0.0, 1.0);
    public static final int INVENTORY_SIZE = 16;
    private static final int EFFECT_EVENT = 0;
    private static final int CRAFTING_SOUND_INTERVAL = 60;
    private boolean hasMaster = false;
    private boolean isMaster = false;
    private BlockPos masterPos;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private FairyRingMode mode = FairyRingMode.NORMAL;
    private int recipeTime;
    private int recipeTimeTotal;
    protected FairyRingRecipe currentRecipe;

    public FairyRingTileEntity() {
        super(ExtendedMushroomsTileEntities.FAIRY_RING);
    }

    public void onLoad() {
        super.onLoad();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            if (this.isMaster() || this.hasMaster()) {
                this.loadRecipe();
                return;
            }
            World world = this.func_145831_w();
            BlockPos pos = this.func_174877_v();
            if (world != null) {
                for (Direction direction : FairyRingBlock.DIRECTIONS) {
                    TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(direction));
                    if (!(tileEntity instanceof FairyRingTileEntity)) continue;
                    this.setMaster(((FairyRingTileEntity)tileEntity).getMaster());
                    break;
                }
            }
            if (!this.hasMaster()) {
                this.setAsMaster();
            }
        }
    }

    public Vector3d getCenter() {
        BlockPos position = this.func_174877_v();
        return new Vector3d((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p()).func_178787_e(CENTER_TRANSLATION_VECTOR);
    }

    public boolean hasMaster() {
        return this.hasMaster;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(FairyRingTileEntity tileEntity) {
        this.isMaster = false;
        this.hasMaster = true;
        this.masterPos = tileEntity.func_174877_v();
        this.sendUpdates();
    }

    public void setAsMaster() {
        this.isMaster = true;
        this.hasMaster = false;
        this.masterPos = this.func_174877_v();
        this.sendUpdates();
    }

    public FairyRingTileEntity getMaster() {
        TileEntity tileEntity;
        if (this.isMaster()) {
            return this;
        }
        if (this.hasMaster() && this.func_145831_w() != null && (tileEntity = this.func_145831_w().func_175625_s(this.masterPos)) instanceof FairyRingTileEntity) {
            return (FairyRingTileEntity)tileEntity;
        }
        return null;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.masterPos = new BlockPos(compound.func_74762_e("MasterX"), compound.func_74762_e("MasterY"), compound.func_74762_e("MasterZ"));
        this.hasMaster = compound.func_74767_n("HasMaster");
        this.isMaster = compound.func_74767_n("IsMaster");
        if (this.isMaster()) {
            this.items = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
            this.mode = FairyRingMode.byName(compound.func_74779_i("Mode"));
            this.recipeTime = compound.func_74762_e("RecipeTime");
            this.recipeTimeTotal = compound.func_74762_e("RecipeTimeTotal");
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("MasterX", this.masterPos.func_177958_n());
        compound.func_74768_a("MasterY", this.masterPos.func_177956_o());
        compound.func_74768_a("MasterZ", this.masterPos.func_177952_p());
        compound.func_74757_a("HasMaster", this.hasMaster);
        compound.func_74757_a("IsMaster", this.isMaster);
        if (this.isMaster()) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
            compound.func_74778_a("Mode", this.mode.getName());
            compound.func_74768_a("RecipeTime", this.recipeTime);
            compound.func_74768_a("RecipeTimeTotal", this.recipeTimeTotal);
        }
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 3, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    private void sendUpdates() {
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void onEntityCollision(Entity entity) {
        if (!this.isMaster()) {
            FairyRingTileEntity master = this.getMaster();
            if (master != null) {
                master.onEntityCollision(entity);
            }
        } else if (entity instanceof ItemEntity) {
            this.onItemEntityCollision((ItemEntity)entity);
        } else if (entity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (!playerEntity.field_71071_by.func_70441_a(stack)) continue;
                this.func_70298_a(i, stack.func_190916_E());
            }
            boolean dirty = false;
            if (this.mode != FairyRingMode.NORMAL) {
                this.mode = FairyRingMode.NORMAL;
                dirty = true;
            }
            if (dirty |= this.updateRecipe()) {
                this.sendUpdates();
            }
        }
    }

    private void onItemEntityCollision(ItemEntity itemEntity) {
        ItemStack remainingStack = this.addItemStack(itemEntity.func_92059_d());
        if (remainingStack == ItemStack.field_190927_a) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(remainingStack);
            Vector3d centerToStack = itemEntity.func_213303_ch().func_178788_d(this.getCenter());
            double scaleFactor = (1.8 - centerToStack.func_72433_c()) * 0.08;
            Vector3d calculatedMotion = new Vector3d(centerToStack.field_72450_a, 0.0, centerToStack.field_72449_c).func_72432_b().func_186678_a(scaleFactor);
            itemEntity.func_213317_d(itemEntity.func_213322_ci().func_178787_e(calculatedMotion));
        }
        if (this.updateRecipe()) {
            this.sendUpdates();
        }
    }

    protected void loadRecipe() {
        if (this.isMaster()) {
            this.currentRecipe = this.getRecipe();
            if (this.currentRecipe == null) {
                this.recipeTime = 0;
                this.recipeTimeTotal = 0;
            }
        }
    }

    protected void resetRecipe() {
        this.currentRecipe = null;
        this.recipeTime = 0;
        this.recipeTimeTotal = 0;
    }

    protected boolean updateRecipe() {
        FairyRingRecipe newRecipe;
        FairyRingRecipe oldRecipe;
        if (this.isMaster() && (oldRecipe = this.currentRecipe) != (newRecipe = this.getRecipe())) {
            this.recipeTime = 0;
            this.recipeTimeTotal = newRecipe != null ? newRecipe.getRecipeTime() : 0;
            this.currentRecipe = newRecipe;
            return true;
        }
        return false;
    }

    protected FairyRingRecipe getRecipe() {
        if (!this.isMaster() || this.func_145831_w() == null || this.func_191420_l()) {
            return null;
        }
        if (this.currentRecipe != null && this.currentRecipe.isValid(this.mode, this)) {
            return this.currentRecipe;
        }
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(ExtendedMushroomsRecipeTypes.FAIRY_RING);
        for (FairyRingRecipe recipe : recipes) {
            if (!recipe.isValid(this.mode, this)) continue;
            return recipe;
        }
        return null;
    }

    protected void setLight(boolean light) {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)FairyRingBlock.LIT, (Comparable)Boolean.valueOf(light)), 3);
        }
    }

    public void func_73660_a() {
        if (this.isMaster() && this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            FairyRingRecipe recipe = this.getRecipe();
            if (recipe != null) {
                Vector3d center;
                if (!((Boolean)this.func_195044_w().func_177229_b((Property)FairyRingBlock.LIT)).booleanValue()) {
                    this.setLight(true);
                }
                if (this.recipeTime % 60 == 1 && this.recipeTimeTotal - this.recipeTime > 30) {
                    center = this.getCenter();
                    float volume = this.func_145831_w().func_201674_k().nextFloat() * 0.4f + 0.8f;
                    float pitch = this.func_145831_w().func_201674_k().nextFloat() * 0.2f + 0.9f;
                    this.func_145831_w().func_184148_a(null, center.field_72450_a, center.field_72448_b, center.field_72449_c, ModSounds.FAIRY_RING_CRAFTING, SoundCategory.AMBIENT, volume, pitch);
                }
                if (this.recipeTime < this.recipeTimeTotal) {
                    ++this.recipeTime;
                }
                if (this.recipeTime >= this.recipeTimeTotal) {
                    if (this.mode != this.currentRecipe.getResultMode()) {
                        this.mode = this.currentRecipe.getResultMode();
                    }
                    this.func_174888_l();
                    center = this.getCenter();
                    ItemStack resultStack = this.currentRecipe.getResultItemStack();
                    if (resultStack != null && resultStack != ItemStack.field_190927_a) {
                        ItemEntity itemEntity = new ItemEntity(this.func_145831_w(), center.field_72450_a, center.field_72448_b + 1.1, center.field_72449_c, resultStack);
                        itemEntity.func_213317_d(new Vector3d(0.0, 0.2, 0.0));
                        this.func_145831_w().func_217376_c((Entity)itemEntity);
                    }
                    this.func_145831_w().func_184148_a(null, center.field_72450_a, center.field_72448_b, center.field_72449_c, ModSounds.FAIRY_RING_CRAFTING_FINISH, SoundCategory.BLOCKS, 1.5f, 1.0f);
                    this.resetRecipe();
                    this.updateRecipe();
                    this.setLight(false);
                }
                this.sendUpdates();
            } else if (((Boolean)this.func_195044_w().func_177229_b((Property)FairyRingBlock.LIT)).booleanValue()) {
                this.setLight(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(World worldIn, Random rand) {
        if (this.isMaster()) {
            int i;
            boolean runningRecipe;
            Vector3d center = this.getCenter();
            boolean bl = runningRecipe = this.recipeTime < this.recipeTimeTotal;
            if (this.mode == FairyRingMode.NORMAL && !runningRecipe) {
                for (i = 0; i < 4; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197596_G, -1.5 + center.field_72450_a + (double)(rand.nextFloat() * 3.0f), center.field_72448_b + (double)0.1f, -1.5 + center.field_72449_c + (double)(rand.nextFloat() * 3.0f), 0.0, 0.0, 0.0);
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    worldIn.func_195594_a((IParticleData)ModParticles.FAIRY_RING, -1.5 + center.field_72450_a + (double)(rand.nextFloat() * 3.0f), center.field_72448_b, -1.5 + center.field_72449_c + (double)(rand.nextFloat() * 3.0f), (rand.nextDouble() - 0.5) * 0.001, 5.0E-4, (rand.nextDouble() - 0.5) * 0.001);
                }
            }
            if (this.mode == FairyRingMode.NORMAL && runningRecipe) {
                for (i = 0; i < 4; ++i) {
                    worldIn.func_195594_a((IParticleData)ModParticles.FAIRY_RING, center.field_72450_a, center.field_72448_b, center.field_72449_c, (rand.nextDouble() - 0.5) * 0.05, 0.05 + rand.nextDouble() * 0.05, (rand.nextDouble() - 0.5) * 0.05);
                }
            }
            if (this.mode != FairyRingMode.NORMAL) {
                double factor = 1.0;
                if (runningRecipe) {
                    factor = 2.0;
                }
                int particleCount = 12;
                double anglePerParticle = 360.0 / (double)particleCount;
                double variance = anglePerParticle / 2.0;
                for (int i2 = 0; i2 < particleCount; ++i2) {
                    double rad = Math.toRadians(anglePerParticle * (double)i2 + (rand.nextDouble() - variance / 2.0) * variance);
                    double x = 1.5 * Math.cos(rad) + center.field_72450_a;
                    double z = 1.5 * Math.sin(rad) + center.field_72449_c;
                    worldIn.func_195594_a((IParticleData)ModParticles.FAIRY_RING, x, center.field_72448_b, z, 0.0, 0.05 * factor, 0.0);
                }
            }
        }
    }

    public boolean func_145842_c(int id, int param) {
        if (id == 0) {
            if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
                Vector3d center = this.getCenter();
                this.func_145831_w().func_195594_a((IParticleData)ParticleTypes.field_197596_G, center.field_72450_a, center.field_72448_b, center.field_72449_c, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return super.func_145842_c(id, param);
    }

    public FairyRingMode getMode() {
        return this.mode;
    }

    public int getRecipeTime() {
        return this.recipeTime;
    }

    public int getRecipeTimeTotal() {
        return this.recipeTimeTotal;
    }

    public ItemStack addItemStack(ItemStack stack) {
        FairyRingTileEntity master = this.getMaster();
        if (stack != null && master != null && !stack.func_190926_b()) {
            boolean dirty = false;
            for (int i = 0; i < master.items.size(); ++i) {
                if (!((ItemStack)master.items.get(i)).func_190926_b()) continue;
                master.func_70299_a(i, stack.func_77979_a(1));
                dirty = true;
                if (stack.func_190926_b()) break;
            }
            if (dirty) {
                this.sendUpdates();
            }
        }
        return stack;
    }

    public int func_70302_i_() {
        FairyRingTileEntity master = this.getMaster();
        if (master != null) {
            return master.items.size();
        }
        return 0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        FairyRingTileEntity master = this.getMaster();
        if (master != null) {
            for (ItemStack itemstack : master.items) {
                if (itemstack.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        FairyRingTileEntity master = this.getMaster();
        if (master != null && slot >= 0 && slot < master.items.size()) {
            return (ItemStack)master.items.get(slot);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        FairyRingTileEntity master = this.getMaster();
        ItemStack stack = ItemStack.field_190927_a;
        if (master != null && count > 0 && slot >= 0 && slot < master.items.size()) {
            stack = ItemStackHelper.func_188382_a(master.items, (int)slot, (int)count);
            this.sendUpdates();
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        FairyRingTileEntity master = this.getMaster();
        if (master != null && slot < master.items.size()) {
            return ItemStackHelper.func_188383_a(master.items, (int)slot);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemStack) {
        FairyRingTileEntity master = this.getMaster();
        if (master != null && slot >= 0 && slot < master.items.size()) {
            master.items.set(slot, (Object)itemStack);
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity playerEntity) {
        return false;
    }

    public void func_174888_l() {
        FairyRingTileEntity master = this.getMaster();
        if (master != null) {
            master.items.clear();
        }
    }
}

