/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.item.crafting;

import cech12.extendedmushrooms.init.ModTags;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MushroomArrowRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<MushroomArrowRecipe> SERIALIZER = new Serializer();
    private static final Map<ITag.INamedTag<Item>, Potion> MUSHROOM_POTION_MAP = new HashMap<ITag.INamedTag<Item>, Potion>();

    public MushroomArrowRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    private Potion getPotionFromMushroom(Item mushroom) {
        for (Map.Entry<ITag.INamedTag<Item>, Potion> entry : MUSHROOM_POTION_MAP.entrySet()) {
            if (!mushroom.func_206844_a((ITag)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        try {
            new RecipeIngredients(inv);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        try {
            RecipeIngredients ingredients = new RecipeIngredients(inv);
            Potion potion = this.getPotionFromMushroom(ingredients.mushroom.func_77973_b());
            if (potion != null) {
                ItemStack tippedArrow = new ItemStack((IItemProvider)Items.field_185167_i, 1);
                PotionUtils.func_185188_a((ItemStack)tippedArrow, (Potion)potion);
                return tippedArrow;
            }
            return ItemStack.field_190927_a;
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    static {
        MUSHROOM_POTION_MAP.putIfAbsent(ModTags.ForgeItems.MUSHROOMS_GLOWSHROOM, Potions.field_185234_f);
        MUSHROOM_POTION_MAP.putIfAbsent(ModTags.ForgeItems.MUSHROOMS_JUMP_BOOSTING, Potions.field_185238_j);
        MUSHROOM_POTION_MAP.putIfAbsent(ModTags.ForgeItems.MUSHROOMS_POISONOUS, Potions.field_185254_z);
        MUSHROOM_POTION_MAP.putIfAbsent(ModTags.ForgeItems.MUSHROOMS_SLOWING_DOWN, Potions.field_185246_r);
    }

    private static class RecipeIngredients {
        ItemStack arrow = null;
        ItemStack mushroom = null;

        RecipeIngredients(@Nonnull CraftingInventory inv) throws Exception {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == Items.field_151032_g) {
                    if (this.arrow == null) {
                        this.arrow = stack;
                        continue;
                    }
                    throw new Exception();
                }
                if (MUSHROOM_POTION_MAP.containsKey(ModTags.ForgeItems.MUSHROOMS_POISONOUS)) {
                    if (this.mushroom == null) {
                        this.mushroom = stack;
                        continue;
                    }
                    throw new Exception();
                }
                throw new Exception();
            }
            if (this.arrow == null || this.mushroom == null) {
                throw new Exception();
            }
        }
    }

    private static class Serializer
    extends SpecialRecipeSerializer<MushroomArrowRecipe> {
        public Serializer() {
            super(MushroomArrowRecipe::new);
            this.setRegistryName("extendedmushrooms", "mushroom_arrow_recipe");
        }
    }
}

