/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.item;

import cech12.extendedmushrooms.api.entity.ExtendedMushroomsEntityTypes;
import cech12.extendedmushrooms.entity.item.MushroomBoatEntity;
import cech12.extendedmushrooms.item.MushroomWoodType;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MushroomBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntityPredicates.field_180132_d.and(Entity::func_70067_L);
    private final MushroomWoodType type;

    public MushroomBoatItem(MushroomWoodType type) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78029_e));
        this.type = type;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenseBehavior(type));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult raytraceresult = MushroomBoatItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        Vector3d vec3d = playerIn.func_70676_i(1.0f);
        List list = worldIn.func_175674_a((Entity)playerIn, playerIn.func_174813_aQ().func_216361_a(vec3d.func_186678_a(5.0)).func_186662_g(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vector3d vec3d1 = playerIn.func_174824_e(1.0f);
            for (Entity entity : list) {
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (!axisalignedbb.func_72318_a(vec3d1)) continue;
                return ActionResult.func_226250_c_((Object)itemstack);
            }
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            MushroomBoatEntity boat = (MushroomBoatEntity)ExtendedMushroomsEntityTypes.MUSHROOM_BOAT.func_200721_a(worldIn);
            if (boat == null) {
                return ActionResult.func_226250_c_((Object)itemstack);
            }
            boat.func_70080_a(raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c, playerIn.field_70177_z, 0.0f);
            boat.setMushroomWoodType(this.type);
            if (!worldIn.func_226665_a__((Entity)boat, boat.func_174813_aQ().func_186662_g(-0.1))) {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)boat);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public static class DispenseBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior dispenseItemBehaviour = new DefaultDispenseItemBehavior();
        private final MushroomWoodType type;

        public DispenseBehavior(MushroomWoodType type) {
            this.type = type;
        }

        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, @Nonnull ItemStack stack) {
            double d3;
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            ServerWorld world = source.func_197524_h();
            double d0 = source.func_82615_a() + (double)((float)direction.func_82601_c() * 1.125f);
            double d1 = source.func_82617_b() + (double)((float)direction.func_96559_d() * 1.125f);
            double d2 = source.func_82616_c() + (double)((float)direction.func_82599_e() * 1.125f);
            BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
            if (world.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                d3 = 1.0;
            } else {
                if (!world.func_180495_p(blockpos).func_196958_f() || !world.func_204610_c(blockpos.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    return this.dispenseItemBehaviour.dispense(source, stack);
                }
                d3 = 0.0;
            }
            MushroomBoatEntity boat = (MushroomBoatEntity)ExtendedMushroomsEntityTypes.MUSHROOM_BOAT.func_200721_a((World)world);
            if (boat != null) {
                boat.func_70080_a(d0, d1 + d3, d2, direction.func_185119_l(), 0.0f);
                boat.setMushroomWoodType(this.type);
                world.func_217376_c((Entity)boat);
                stack.func_190918_g(1);
            }
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_217379_c(1000, source.func_180699_d(), 0);
        }
    }
}

