/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.init;

import cech12.extendedmushrooms.api.block.ExtendedMushroomsBlocks;
import cech12.extendedmushrooms.api.tileentity.ExtendedMushroomsTileEntities;
import cech12.extendedmushrooms.client.renderer.tileentity.FairyRingTileEntityRenderer;
import cech12.extendedmushrooms.client.renderer.tileentity.VariantChestTileEntityRenderer;
import cech12.extendedmushrooms.client.renderer.tileentity.VariantTrappedChestTileEntityRenderer;
import cech12.extendedmushrooms.init.ModBlocks;
import cech12.extendedmushrooms.item.MushroomWoodType;
import cech12.extendedmushrooms.tileentity.FairyRingTileEntity;
import cech12.extendedmushrooms.tileentity.MushroomSignTileEntity;
import cech12.extendedmushrooms.tileentity.VariantChestTileEntity;
import cech12.extendedmushrooms.tileentity.VariantTrappedChestTileEntity;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.WoodType;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="extendedmushrooms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModTileEntities {
    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        ExtendedMushroomsTileEntities.FAIRY_RING = ModTileEntities.register(event, FairyRingTileEntity::new, "fairy_ring", ExtendedMushroomsBlocks.FAIRY_RING);
        ExtendedMushroomsTileEntities.MUSHROOM_SIGN = ModTileEntities.register(event, MushroomSignTileEntity::new, "mushroom_sign", (Block)ModBlocks.MUSHROOM_STANDING_SIGN.get(), (Block)ModBlocks.MUSHROOM_WALL_SIGN.get(), (Block)ModBlocks.GLOWSHROOM_STANDING_SIGN.get(), (Block)ModBlocks.GLOWSHROOM_WALL_SIGN.get(), (Block)ModBlocks.POISONOUS_MUSHROOM_STANDING_SIGN.get(), (Block)ModBlocks.POISONOUS_MUSHROOM_WALL_SIGN.get(), (Block)ModBlocks.HONEY_FUNGUS_STANDING_SIGN.get(), (Block)ModBlocks.HONEY_FUNGUS_WALL_SIGN.get());
        ExtendedMushroomsTileEntities.VARIANT_CHEST = ModTileEntities.register(event, VariantChestTileEntity::new, "variant_chest", ExtendedMushroomsBlocks.MUSHROOM_CHEST, ExtendedMushroomsBlocks.GLOWSHROOM_CHEST, ExtendedMushroomsBlocks.POISONOUS_MUSHROOM_CHEST, ExtendedMushroomsBlocks.HONEY_FUNGUS_CHEST);
        ExtendedMushroomsTileEntities.VARIANT_TRAPPED_CHEST = ModTileEntities.register(event, VariantTrappedChestTileEntity::new, "variant_trapped_chest", ExtendedMushroomsBlocks.MUSHROOM_CHEST_TRAPPED, ExtendedMushroomsBlocks.GLOWSHROOM_CHEST_TRAPPED, ExtendedMushroomsBlocks.POISONOUS_MUSHROOM_CHEST_TRAPPED, ExtendedMushroomsBlocks.HONEY_FUNGUS_CHEST_TRAPPED);
    }

    private static <T extends TileEntity> TileEntityType<T> register(RegistryEvent.Register<TileEntityType<?>> registryEvent, Supplier<T> supplier, String registryName, Block ... blocks) {
        TileEntityType tileEntityType = TileEntityType.Builder.func_223042_a(supplier, (Block[])blocks).func_206865_a(null);
        tileEntityType.setRegistryName(registryName);
        registryEvent.getRegistry().register((IForgeRegistryEntry)tileEntityType);
        return tileEntityType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupRenderers(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(ExtendedMushroomsTileEntities.FAIRY_RING, FairyRingTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ExtendedMushroomsTileEntities.MUSHROOM_SIGN, SignTileEntityRenderer::new);
        event.enqueueWork(() -> {
            for (MushroomWoodType type : MushroomWoodType.values()) {
                Atlases.addWoodType((WoodType)type.getWoodType());
            }
        });
        ClientRegistry.bindTileEntityRenderer(ExtendedMushroomsTileEntities.VARIANT_CHEST, VariantChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ExtendedMushroomsTileEntities.VARIANT_TRAPPED_CHEST, VariantTrappedChestTileEntityRenderer::new);
    }
}

