/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.init;

import cech12.extendedmushrooms.api.block.ExtendedMushroomsBlocks;
import cech12.extendedmushrooms.block.mushrooms.BrownMushroom;
import cech12.extendedmushrooms.block.mushrooms.Glowshroom;
import cech12.extendedmushrooms.block.mushrooms.HoneyFungus;
import cech12.extendedmushrooms.block.mushrooms.PoisonousMushroom;
import cech12.extendedmushrooms.block.mushrooms.RedMushroom;
import cech12.extendedmushrooms.block.mushrooms.SlimeFungus;
import cech12.extendedmushrooms.config.Config;
import cech12.extendedmushrooms.world.gen.feature.BigGlowshroomFeature;
import cech12.extendedmushrooms.world.gen.feature.BigHoneyFungusFeature;
import cech12.extendedmushrooms.world.gen.feature.BigMushroomFeature;
import cech12.extendedmushrooms.world.gen.feature.BigPoisonousMushroomFeature;
import cech12.extendedmushrooms.world.gen.feature.BigSlimeFungusFeature;
import cech12.extendedmushrooms.world.gen.feature.MegaBrownMushroomFeature;
import cech12.extendedmushrooms.world.gen.feature.MegaGlowshroomFeature;
import cech12.extendedmushrooms.world.gen.feature.MegaPoisonousMushroomFeature;
import cech12.extendedmushrooms.world.gen.feature.MegaRedMushroomFeature;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="extendedmushrooms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    private static List<Mushroom> mushrooms = null;
    private static List<BigMushroom> bigMushrooms = null;
    private static List<BigMushroom> megaMushrooms = null;

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.register("infested_grass", Configured.INFESTED_FLOWER);
        ModFeatures.register("infested_flower", Configured.INFESTED_GRASS);
        ModFeatures.register("mega_brown_mushroom", NotConfigured.MEGA_BROWN_MUSHROOM, Configured.MEGA_BROWN_MUSHROOM);
        ModFeatures.register("mega_red_mushroom", NotConfigured.MEGA_RED_MUSHROOM, Configured.MEGA_RED_MUSHROOM);
        ModFeatures.register("big_glowshroom", NotConfigured.BIG_GLOWSHROOM, Configured.BIG_GLOWSHROOM);
        ModFeatures.register("mega_glowshroom", NotConfigured.MEGA_GLOWSHROOM, Configured.MEGA_GLOWSHROOM);
        ModFeatures.register("big_poisonous_mushroom", NotConfigured.BIG_POISONOUS_MUSHROOM, Configured.BIG_POISONOUS_MUSHROOM);
        ModFeatures.register("mega_poisonous_mushroom", NotConfigured.MEGA_POISONOUS_MUSHROOM, Configured.MEGA_POISONOUS_MUSHROOM);
        ModFeatures.register("big_slime_fungus", NotConfigured.BIG_SLIME_FUNGUS, Configured.BIG_SLIME_FUNGUS);
        ModFeatures.register("big_honey_fungus", NotConfigured.BIG_HONEY_FUNGUS, Configured.BIG_HONEY_FUNGUS);
        if (mushrooms == null || bigMushrooms == null || megaMushrooms == null) {
            mushrooms = new LinkedList<Mushroom>();
            bigMushrooms = new LinkedList<BigMushroom>();
            megaMushrooms = new LinkedList<BigMushroom>();
            megaMushrooms.add(new BigMushroom("mega_red_mushroom", Configured.MEGA_RED_MUSHROOM, 0.2f, Config.VANILLA_MEGA_MUSHROOM_GENERATION_ENABLED));
            megaMushrooms.add(new BigMushroom("mega_brown_mushroom", Configured.MEGA_BROWN_MUSHROOM, 0.2f, Config.VANILLA_MEGA_MUSHROOM_GENERATION_ENABLED));
            mushrooms.add(new Mushroom("glowshroom", ExtendedMushroomsBlocks.GLOWSHROOM, 0.4f, 32, Config.GLOWSHROOM_GENERATION_ENABLED));
            bigMushrooms.add(new BigMushroom("big_glowshroom", Configured.BIG_GLOWSHROOM, 0.15f, Config.BIG_GLOWSHROOM_GENERATION_ENABLED));
            megaMushrooms.add(new BigMushroom("mega_glowshroom", Configured.MEGA_GLOWSHROOM, 0.02f, Config.MEGA_GLOWSHROOM_GENERATION_ENABLED));
            mushrooms.add(new Mushroom("poisonous_mushroom", ExtendedMushroomsBlocks.POISONOUS_MUSHROOM, 0.5, 32, Config.POISONOUS_MUSHROOM_GENERATION_ENABLED));
            bigMushrooms.add(new BigMushroom("big_poisonous_mushroom", Configured.BIG_POISONOUS_MUSHROOM, 0.1f, Config.BIG_POISONOUS_MUSHROOM_GENERATION_ENABLED));
            megaMushrooms.add(new BigMushroom("mega_poisonous_mushroom", Configured.MEGA_POISONOUS_MUSHROOM, 0.02f, Config.MEGA_POISONOUS_MUSHROOM_GENERATION_ENABLED));
            for (Mushroom mushroom : mushrooms) {
                int chance = Math.max(1, (int)(4.0 / mushroom.spawnFactor));
                ModFeatures.register(mushroom.name + "_normal", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)mushroom.config).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(chance));
                ModFeatures.register(mushroom.name + "_taiga", (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)mushroom.config).func_227228_a_(Features.Placements.field_244001_l).func_242729_a(chance));
                ModFeatures.register(mushroom.name + "_swamp", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)mushroom.config).func_227228_a_(Features.Placements.field_244001_l).func_242729_a(chance)).func_242731_b(8));
                ModFeatures.register(mushroom.name + "_nether", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)mushroom.config).func_242733_d(128)).func_242729_a(Math.max(1, chance / 2)));
            }
            for (BigMushroom bigMushroom : bigMushrooms) {
                ModFeatures.register(bigMushroom.name + "_field", bigMushroom.config.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, bigMushroom.spawnChance, 1))));
            }
            for (BigMushroom megaMushroom : megaMushrooms) {
                ModFeatures.register(megaMushroom.name + "_field", megaMushroom.config.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, megaMushroom.spawnChance, 1))));
            }
        }
    }

    private static <FC extends IFeatureConfig> void register(String key, Feature<?> feature, ConfiguredFeature<FC, ?> configuredFeature) {
        feature.setRegistryName(new ResourceLocation("extendedmushrooms", key));
        ForgeRegistries.FEATURES.register(feature);
        ModFeatures.register(key, configuredFeature);
    }

    private static <FC extends IFeatureConfig> void register(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("extendedmushrooms", key), configuredFeature);
    }

    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.MUSHROOM)) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            if (((Boolean)Config.INFESTED_GRASS_ENABLED.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.INFESTED_GRASS);
            }
            if (((Boolean)Config.INFESTED_FLOWER_ENABLED.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.INFESTED_FLOWER);
            }
        }
        ModFeatures.addMushrooms(event);
        ModFeatures.addBigMushrooms(event);
        ModFeatures.addMegaMushrooms(event);
    }

    private static boolean biomeHasNoMushrooms(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        Biome.TemperatureModifier temperatureModifier = event.getClimate().field_242462_d;
        return category == Biome.Category.THEEND || category == Biome.Category.OCEAN && temperatureModifier != Biome.TemperatureModifier.FROZEN;
    }

    private static void addMushrooms(BiomeLoadingEvent event) {
        if (ModFeatures.biomeHasNoMushrooms(event)) {
            return;
        }
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        for (Mushroom mushroom : mushrooms) {
            if (!((Boolean)mushroom.enableConfig.get()).booleanValue()) continue;
            WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation("extendedmushrooms", mushroom.name + "_normal")).ifPresent(feature -> generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature));
            String suffix = null;
            switch (event.getCategory()) {
                case MUSHROOM: 
                case TAIGA: {
                    suffix = "_taiga";
                    break;
                }
                case SWAMP: {
                    suffix = "_swamp";
                    break;
                }
                case NETHER: {
                    suffix = "_nether";
                }
            }
            if (suffix == null) continue;
            WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation("extendedmushrooms", mushroom.name + suffix)).ifPresent(feature -> generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature));
        }
    }

    private static void addBigMushrooms(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.MUSHROOM) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            for (BigMushroom bigMushroom : bigMushrooms) {
                if (!((Boolean)bigMushroom.enableConfig.get()).booleanValue()) continue;
                WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation("extendedmushrooms", bigMushroom.name + "_field")).ifPresent(feature -> generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature));
            }
        }
    }

    private static void addMegaMushrooms(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.MUSHROOM) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            for (BigMushroom megaMushroom : megaMushrooms) {
                if (!((Boolean)megaMushroom.enableConfig.get()).booleanValue()) continue;
                WorldGenRegistries.field_243653_e.func_241873_b(new ResourceLocation("extendedmushrooms", megaMushroom.name + "_field")).ifPresent(feature -> generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature));
            }
        }
    }

    private static class BigMushroom {
        String name;
        ConfiguredFeature<BigMushroomFeatureConfig, ?> config;
        float spawnChance;
        ForgeConfigSpec.BooleanValue enableConfig;

        private BigMushroom(String name, ConfiguredFeature<BigMushroomFeatureConfig, ?> config, float spawnChance, ForgeConfigSpec.BooleanValue enableConfig) {
            this.name = name;
            this.config = config;
            this.spawnChance = spawnChance;
            this.enableConfig = enableConfig;
        }
    }

    private static class Mushroom {
        String name;
        Block block;
        double spawnFactor;
        ForgeConfigSpec.BooleanValue enableConfig;
        BlockClusterFeatureConfig config;

        private Mushroom(String name, Block mushroomBlock, double spawnFactor, int spawnTryCount, ForgeConfigSpec.BooleanValue enableConfig) {
            this.name = name;
            this.block = mushroomBlock;
            this.spawnFactor = spawnFactor;
            this.enableConfig = enableConfig;
            this.config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(mushroomBlock.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(spawnTryCount).func_227317_b_().func_227322_d_();
        }
    }

    public static final class Configured {
        public static ConfiguredFeature<?, ?> INFESTED_FLOWER = (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ExtendedMushroomsBlocks.INFESTED_FLOWER.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4);
        public static ConfiguredFeature<?, ?> INFESTED_GRASS = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ExtendedMushroomsBlocks.INFESTED_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_()).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(2);
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> MEGA_BROWN_MUSHROOM = NotConfigured.MEGA_BROWN_MUSHROOM.func_225566_b_((IFeatureConfig)BrownMushroom.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> MEGA_RED_MUSHROOM = NotConfigured.MEGA_RED_MUSHROOM.func_225566_b_((IFeatureConfig)RedMushroom.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> BIG_GLOWSHROOM = NotConfigured.BIG_GLOWSHROOM.func_225566_b_((IFeatureConfig)Glowshroom.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> MEGA_GLOWSHROOM = NotConfigured.MEGA_GLOWSHROOM.func_225566_b_((IFeatureConfig)Glowshroom.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> BIG_POISONOUS_MUSHROOM = NotConfigured.BIG_POISONOUS_MUSHROOM.func_225566_b_((IFeatureConfig)PoisonousMushroom.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> MEGA_POISONOUS_MUSHROOM = NotConfigured.MEGA_POISONOUS_MUSHROOM.func_225566_b_((IFeatureConfig)PoisonousMushroom.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> BIG_SLIME_FUNGUS = NotConfigured.BIG_SLIME_FUNGUS.func_225566_b_((IFeatureConfig)SlimeFungus.getConfig());
        public static ConfiguredFeature<BigMushroomFeatureConfig, ?> BIG_HONEY_FUNGUS = NotConfigured.BIG_HONEY_FUNGUS.func_225566_b_((IFeatureConfig)HoneyFungus.getConfig());
    }

    public static final class NotConfigured {
        public static BigMushroomFeature MEGA_BROWN_MUSHROOM = new MegaBrownMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature MEGA_RED_MUSHROOM = new MegaRedMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature BIG_GLOWSHROOM = new BigGlowshroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature MEGA_GLOWSHROOM = new MegaGlowshroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature BIG_POISONOUS_MUSHROOM = new BigPoisonousMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature MEGA_POISONOUS_MUSHROOM = new MegaPoisonousMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature BIG_SLIME_FUNGUS = new BigSlimeFungusFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
        public static BigMushroomFeature BIG_HONEY_FUNGUS = new BigHoneyFungusFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
    }
}

