/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.entity.passive;

import cech12.extendedmushrooms.api.entity.ExtendedMushroomsEntityTypes;
import cech12.extendedmushrooms.config.Config;
import cech12.extendedmushrooms.entity.ai.goal.EatMyceliumGoal;
import cech12.extendedmushrooms.init.ModTags;
import cech12.extendedmushrooms.item.MushroomType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class MushroomSheepEntity
extends SheepEntity {
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(MushroomSheepEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> MUSHROOM_TYPE = EntityDataManager.func_187226_a(MushroomSheepEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private int sheepTimer;
    private EatMyceliumGoal eatMyceliumGoal;

    public MushroomSheepEntity(EntityType<? extends SheepEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static void replaceSheep(@Nonnull SheepEntity sheep, @Nullable MushroomType mushroomType) {
        sheep.func_70659_e(0.0f);
        World world = sheep.field_70170_p;
        MushroomSheepEntity mushroomSheep = (MushroomSheepEntity)ExtendedMushroomsEntityTypes.MUSHROOM_SHEEP.func_200721_a(world);
        if (mushroomSheep != null && world instanceof ServerWorld) {
            mushroomSheep.func_82149_j((Entity)sheep);
            mushroomSheep.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(sheep.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
            mushroomSheep.func_70873_a(sheep.func_70874_b());
            if (sheep.func_145818_k_()) {
                mushroomSheep.func_200203_b(sheep.func_200201_e());
                mushroomSheep.func_174805_g(sheep.func_174833_aM());
            }
            mushroomSheep.func_70606_j(sheep.func_110143_aJ());
            if (mushroomType != null) {
                mushroomSheep.setMushroomType(mushroomType);
                mushroomSheep.activateMushroomEffect(mushroomType);
            }
            sheep.func_70106_y();
            world.func_217376_c((Entity)mushroomSheep);
            mushroomSheep.func_184185_a(SoundEvents.field_187941_ho, 2.0f, 1.0f);
        }
    }

    protected void func_184651_r() {
        this.field_146087_bs = new EatGrassGoal((MobEntity)this);
        this.eatMyceliumGoal = new EatMyceliumGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        for (Item mushroom : Tags.Items.MUSHROOMS.func_230236_b_()) {
            this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{mushroom}), false));
        }
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatMyceliumGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.eatMyceliumGoal.getEatingTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(MUSHROOM_TYPE, (Object)new ItemStack((IItemProvider)MushroomType.byId(0).getItem()));
    }

    @Nonnull
    public ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return this.func_200600_R().func_220348_g();
        }
        return this.getMushroomType().getSheepLootTable();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70894_j(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70890_k(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Nonnull
    public ActionResultType func_230254_b_(PlayerEntity player, @Nonnull Hand hand) {
        MushroomType type;
        Item item = player.func_184586_b(hand).func_77973_b();
        ActionResultType superResult = super.func_230254_b_(player, hand);
        if (superResult.func_226246_a_() && ((Boolean)Config.SHEEP_ABSORB_MUSHROOM_TYPE_ENABLED.get()).booleanValue() && item.func_206844_a((ITag)Tags.Items.MUSHROOMS) && (type = MushroomType.byItemOrNull(item)) != null && type != this.getMushroomType()) {
            this.setMushroomType(type);
            this.activateMushroomEffect(type);
            return ActionResultType.SUCCESS;
        }
        return superResult;
    }

    public void activateMushroomEffect(MushroomType mushroomType) {
        if (mushroomType.getItem().func_206844_a(ModTags.ForgeItems.MUSHROOMS_POISONOUS)) {
            this.func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a((ITag)Tags.Items.MUSHROOMS);
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74768_a("Mushroom", this.getMushroomType().getId());
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.setMushroomType(MushroomType.byId(compound.func_74762_e("Mushroom")));
    }

    public MushroomType getMushroomType() {
        return MushroomType.byItem(((ItemStack)this.field_70180_af.func_187225_a(MUSHROOM_TYPE)).func_77973_b());
    }

    public void setMushroomType(MushroomType mushroomType) {
        this.field_70180_af.func_187227_b(MUSHROOM_TYPE, (Object)new ItemStack((IItemProvider)mushroomType.getItem()));
        super.func_175512_b(mushroomType.getColor());
    }

    @Nonnull
    public DyeColor func_175509_cj() {
        return this.getMushroomType().getColor();
    }

    @Deprecated
    public void func_175512_b(@Nonnull DyeColor color) {
    }

    public boolean func_70892_o() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void func_70893_e(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
        super.func_70893_e(sheared);
    }

    public static MushroomType getRandomMushroomType(Random random) {
        if (random.nextInt(100) < 5) {
            MushroomType[] specialTypes = MushroomType.getSpecialTypes();
            return specialTypes[random.nextInt(specialTypes.length)];
        }
        if (random.nextBoolean()) {
            return MushroomType.BROWN_MUSHROOM;
        }
        return MushroomType.RED_MUSHROOM;
    }

    public SheepEntity func_241840_a(@Nonnull ServerWorld world, @Nonnull AgeableEntity ageable) {
        if (ageable instanceof MushroomSheepEntity) {
            MushroomSheepEntity child = (MushroomSheepEntity)ExtendedMushroomsEntityTypes.MUSHROOM_SHEEP.func_200721_a((World)world);
            if (child != null) {
                child.setMushroomType(this.getMushroomTypeMixFromParents(this, (MushroomSheepEntity)ageable));
                return child;
            }
        } else {
            SheepEntity child = (SheepEntity)EntityType.field_200737_ac.func_200721_a((World)world);
            if (child != null) {
                child.func_175512_b(((SheepEntity)ageable).func_175509_cj());
                return child;
            }
        }
        return null;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setMushroomType(MushroomSheepEntity.getRandomMushroomType(worldIn.func_201674_k()));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private MushroomType getMushroomTypeMixFromParents(MushroomSheepEntity father, MushroomSheepEntity mother) {
        if (father.func_70681_au().nextBoolean()) {
            return father.getMushroomType();
        }
        return mother.getMushroomType();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, @Nonnull World world, @Nonnull BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70893_e(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ret.add(new ItemStack((IItemProvider)this.getMushroomType().getCapBlock()));
            }
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }
}

