/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data.recipes;

import cech12.extendedmushrooms.api.recipe.FairyRingMode;
import cech12.extendedmushrooms.api.recipe.FairyRingRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FairyRingRecipeBuilder {
    private final Item result;
    private final int resultCount;
    private final List<Ingredient> ingredients;
    private final FairyRingMode requiredMode;
    private int recipeTime;
    private FairyRingMode resultMode;

    private FairyRingRecipeBuilder(IItemProvider result, int resultCount, FairyRingMode requiredMode) {
        this.result = result.func_199767_j();
        this.resultCount = resultCount;
        this.resultMode = requiredMode;
        this.ingredients = new ArrayList<Ingredient>();
        this.requiredMode = requiredMode;
        this.recipeTime = 200;
    }

    public static FairyRingRecipeBuilder normal(IItemProvider result, int resultCount) {
        return new FairyRingRecipeBuilder(result, resultCount, FairyRingMode.NORMAL);
    }

    public static FairyRingRecipeBuilder fairy(IItemProvider result, int resultCount) {
        return new FairyRingRecipeBuilder(result, resultCount, FairyRingMode.FAIRY);
    }

    public static FairyRingRecipeBuilder witch(IItemProvider result, int resultCount) {
        return new FairyRingRecipeBuilder(result, resultCount, FairyRingMode.WITCH);
    }

    public FairyRingRecipeBuilder requires(ITag<Item> tag) {
        return this.requires(Ingredient.func_199805_a(tag));
    }

    public FairyRingRecipeBuilder requires(IItemProvider iItemProvider) {
        return this.requires(iItemProvider, 1);
    }

    public FairyRingRecipeBuilder requires(IItemProvider itemProvider, int count) {
        return this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}), count);
    }

    public FairyRingRecipeBuilder requires(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public FairyRingRecipeBuilder requires(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public FairyRingRecipeBuilder recipeTime(int time) {
        this.recipeTime = time;
        return this;
    }

    public FairyRingRecipeBuilder resultMode(FairyRingMode mode) {
        this.resultMode = mode;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> consumer, String location) {
        ResourceLocation resourceLocation = new ResourceLocation(location);
        if (resourceLocation.equals((Object)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result))) {
            throw new IllegalStateException("Recipe " + resourceLocation + " should remove its 'save' argument");
        }
        this.save(consumer, resourceLocation);
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        consumer.accept(new Result(resourceLocation, this.result, this.resultCount, this.resultMode, this.ingredients, this.requiredMode, this.recipeTime));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation resourceLocation;
        private final Item result;
        private final int resultCount;
        private final FairyRingMode resultMode;
        private final List<Ingredient> ingredients;
        private final FairyRingMode requiredMode;
        private final int recipeTime;

        public Result(ResourceLocation resourceLocation, Item result, int resultCount, FairyRingMode resultMode, List<Ingredient> ingredients, FairyRingMode requiredMode, int recipeTime) {
            this.resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), "fairy_ring/" + resourceLocation.func_110623_a());
            this.result = result.func_199767_j();
            this.resultCount = resultCount;
            this.resultMode = resultMode;
            this.ingredients = ingredients;
            this.requiredMode = requiredMode;
            this.recipeTime = recipeTime;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray jsonArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonArray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonArray);
            json.addProperty("recipeTime", (Number)this.recipeTime);
            if (this.requiredMode != FairyRingMode.NORMAL) {
                json.addProperty("mode", this.requiredMode.getName());
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.resultCount > 1) {
                jsonObject.addProperty("count", (Number)this.resultCount);
            }
            if (this.resultMode != this.requiredMode) {
                jsonObject.addProperty("mode", this.resultMode.getName());
            }
            json.add("result", (JsonElement)jsonObject);
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return FairyRingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.resourceLocation;
        }
    }
}

