/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data;

import cech12.extendedmushrooms.block.VariantChestBlock;
import cech12.extendedmushrooms.block.VariantTrappedChestBlock;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelProvider
extends net.minecraftforge.client.model.generators.ItemModelProvider {
    private static final ResourceLocation ITEM_GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation SPAWN_EGG = new ResourceLocation("item/template_spawn_egg");

    public ItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "extendedmushrooms", existingFileHelper);
    }

    private static ResourceLocation getResourceLocation(String path) {
        return new ResourceLocation("extendedmushrooms", path);
    }

    private static ResourceLocation getBlockResourceLocation(String name) {
        return ItemModelProvider.getResourceLocation("block/" + name);
    }

    private static ResourceLocation getBlockResourceLocation(String name, String removeSuffix, String addSuffix) {
        return ItemModelProvider.getBlockResourceLocation(name.substring(0, name.length() - removeSuffix.length()) + addSuffix);
    }

    private static ResourceLocation getItemResourceLocation(String name) {
        return ItemModelProvider.getResourceLocation("item/" + name);
    }

    protected void registerModels() {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!"extendedmushrooms".equals(item.getRegistryName().func_110624_b())) continue;
            String name = item.getRegistryName().func_110623_a();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.func_179223_d();
                if (block instanceof BushBlock || block instanceof LadderBlock) {
                    this.singleTexture(name, ITEM_GENERATED, "layer0", ItemModelProvider.getBlockResourceLocation(name));
                    continue;
                }
                if (block instanceof VariantChestBlock || block instanceof VariantTrappedChestBlock) {
                    ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", ItemModelProvider.getBlockResourceLocation(name.replace("_trapped", ""), "_chest", "_planks"))).transforms().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f, 0.5f, 0.5f).end().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 315.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().end();
                    continue;
                }
                if (block instanceof StandingSignBlock) {
                    this.singleTexture(name, ITEM_GENERATED, "layer0", ItemModelProvider.getItemResourceLocation(name));
                    continue;
                }
                if (block instanceof DoorBlock) {
                    this.singleTexture(name, ITEM_GENERATED, "layer0", ItemModelProvider.getItemResourceLocation(name));
                    continue;
                }
                if (block instanceof HugeMushroomBlock || block instanceof AbstractButtonBlock || block instanceof FenceBlock) {
                    this.withExistingParent(name, ItemModelProvider.getBlockResourceLocation(name + "_inventory"));
                    continue;
                }
                if (block instanceof TrapDoorBlock) {
                    this.withExistingParent(name, ItemModelProvider.getBlockResourceLocation(name + "_bottom"));
                    continue;
                }
                this.withExistingParent(name, ItemModelProvider.getBlockResourceLocation(name));
                continue;
            }
            if (item instanceof SpawnEggItem) {
                this.withExistingParent(name, SPAWN_EGG);
                continue;
            }
            this.singleTexture(name, ITEM_GENERATED, "layer0", ItemModelProvider.getItemResourceLocation(name));
        }
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        super.func_200398_a(cache);
    }

    @Nonnull
    public String func_200397_b() {
        return "Extended Mushrooms Item Models";
    }
}

