/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data;

import cech12.extendedmushrooms.item.MushroomType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class EntityLootProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<MushroomType, Function<MushroomType, LootTable.Builder>> functionTable = new HashMap<MushroomType, Function<MushroomType, LootTable.Builder>>();

    public EntityLootProvider(DataGenerator generator) {
        this.generator = generator;
        for (MushroomType mushroomType : MushroomType.values()) {
            this.functionTable.put(mushroomType, EntityLootProvider::createSheepTable);
        }
    }

    private static Path getSheepPath(Path root, ResourceLocation id) {
        return root.resolve("data/extendedmushrooms/loot_tables/entities/sheep/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder createSheepTable(MushroomType mushroomType) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)mushroomType.getCapBlock()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)EntityType.field_200737_ac.func_220348_g())));
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (MushroomType mushroomType : MushroomType.values()) {
            Function<MushroomType, LootTable.Builder> func = this.functionTable.get((Object)mushroomType);
            tables.put(mushroomType.getItem().getRegistryName(), func.apply(mushroomType));
        }
        for (Map.Entry entry : tables.entrySet()) {
            Path path = EntityLootProvider.getSheepPath(this.generator.func_200391_b(), (ResourceLocation)entry.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)entry.getValue()).func_216039_a(LootParameterSets.field_216263_d).func_216038_b()), (Path)path);
        }
    }

    @Nonnull
    public String func_200397_b() {
        return "Extended Mushrooms entity loot tables";
    }
}

