/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data;

import cech12.extendedmushrooms.block.FairyRingBlock;
import cech12.extendedmushrooms.block.VariantChestBlock;
import cech12.extendedmushrooms.block.VariantTrappedChestBlock;
import cech12.extendedmushrooms.block.VerticalSlabBlock;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStateProvider
extends net.minecraftforge.client.model.generators.BlockStateProvider {
    public BlockStateProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "extendedmushrooms", fileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Extended Mushrooms Blockstates";
    }

    private static ResourceLocation getResourceLocation(String path) {
        return new ResourceLocation("extendedmushrooms", path);
    }

    private static ResourceLocation getBlockResourceLocation(String name) {
        return BlockStateProvider.getResourceLocation("block/" + name);
    }

    private static ResourceLocation getBlockResourceLocation(String name, String removeSuffix, String addSuffix) {
        return BlockStateProvider.getBlockResourceLocation(name.substring(0, name.length() - removeSuffix.length()) + addSuffix);
    }

    private static ResourceLocation getInsideResourceLocation(String name) {
        if ("stripped_mushroom_stem".equals(name)) {
            return new ResourceLocation("block/mushroom_block_inside");
        }
        return BlockStateProvider.getBlockResourceLocation(name.replace("_cap", "").replace("_stem", "").replace("_stripped", "") + "_inside");
    }

    protected void registerStatesAndModels() {
        for (Block block : ForgeRegistries.BLOCKS) {
            ModelFile.ExistingModelFile top;
            ModelFile.ExistingModelFile bottom;
            if (!"extendedmushrooms".equals(block.getRegistryName().func_110624_b())) continue;
            String name = block.getRegistryName().func_110623_a();
            if (block instanceof WoodButtonBlock) {
                ModelFile.ExistingModelFile button = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                ModelFile.ExistingModelFile pressed_button = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_pressed"));
                this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStateProvider.lambda$registerStatesAndModels$0((ModelFile)pressed_button, (ModelFile)button, arg_0));
                continue;
            }
            if (block instanceof HugeMushroomBlock) {
                ModelFile.ExistingModelFile outside = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                ModelFile.ExistingModelFile inside = this.models().getExistingFile(BlockStateProvider.getInsideResourceLocation(name));
                MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
                for (boolean boolValue : new boolean[]{true, false}) {
                    for (Map.Entry entry : SixWayBlock.field_196491_B.entrySet()) {
                        int xRot = 0;
                        int yRot = 0;
                        switch ((Direction)entry.getKey()) {
                            case EAST: {
                                yRot = 90;
                                break;
                            }
                            case SOUTH: {
                                yRot = 180;
                                break;
                            }
                            case WEST: {
                                yRot = 270;
                                break;
                            }
                            case UP: {
                                xRot = 270;
                                break;
                            }
                            case DOWN: {
                                xRot = 90;
                                break;
                            }
                        }
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(boolValue ? outside : inside)).rotationX(xRot).rotationY(yRot).uvLock(boolValue).addModel()).condition((Property)entry.getValue(), (Comparable[])new Boolean[]{boolValue}).end();
                    }
                }
                continue;
            }
            if (block instanceof VariantChestBlock || block instanceof VariantTrappedChestBlock) {
                this.simpleBlock(block, (ModelFile)this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name.replace("_trapped", ""))));
                continue;
            }
            if (block instanceof DoorBlock) {
                bottom = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_bottom"));
                ModelFile.ExistingModelFile bottomHinge = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_bottom_hinge"));
                ModelFile.ExistingModelFile top2 = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_top"));
                ModelFile.ExistingModelFile topHinge = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_top_hinge"));
                this.doorBlock((DoorBlock)block, (ModelFile)bottom, (ModelFile)bottomHinge, (ModelFile)top2, (ModelFile)topHinge);
                continue;
            }
            if (block instanceof FenceGateBlock) {
                ModelFile.ExistingModelFile gate = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                ModelFile.ExistingModelFile gateOpen = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_open"));
                ModelFile.ExistingModelFile wall = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_wall"));
                ModelFile.ExistingModelFile wallOpen = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_wall_open"));
                this.fenceGateBlock((FenceGateBlock)block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)wall, (ModelFile)wallOpen);
                continue;
            }
            if (block instanceof FenceBlock) {
                ModelFile.ExistingModelFile post = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_post"));
                ModelFile.ExistingModelFile side = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_side"));
                this.fourWayBlock((FourWayBlock)((FenceBlock)block), (ModelFile)post, (ModelFile)side);
                continue;
            }
            if (block instanceof LadderBlock) {
                ModelFile.ExistingModelFile ladder = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> BlockStateProvider.lambda$registerStatesAndModels$1((ModelFile)ladder, arg_0), new Property[]{LadderBlock.field_204612_b});
                continue;
            }
            if (block instanceof PressurePlateBlock) {
                ModelFile.ExistingModelFile plate = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                ModelFile.ExistingModelFile plate_down = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_down"));
                this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> BlockStateProvider.lambda$registerStatesAndModels$2((ModelFile)plate_down, (ModelFile)plate, arg_0), new Property[0]);
                continue;
            }
            if (block instanceof StandingSignBlock) {
                this.simpleBlock(block, (ModelFile)this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name)));
                continue;
            }
            if (block instanceof WallSignBlock) {
                this.simpleBlock(block, (ModelFile)this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name.replace("_wall", ""))));
                continue;
            }
            if (block instanceof SlabBlock) {
                bottom = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                top = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_top"));
                ModelFile.ExistingModelFile doubleSlab = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name, "_slab", "_planks"));
                this.slabBlock((SlabBlock)block, (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
                continue;
            }
            if (block instanceof StairsBlock) {
                ModelFile.ExistingModelFile stair = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                ModelFile.ExistingModelFile inner = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_inner"));
                ModelFile.ExistingModelFile outer = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_outer"));
                this.stairsBlock((StairsBlock)block, (ModelFile)stair, (ModelFile)inner, (ModelFile)outer);
                continue;
            }
            if (block instanceof TrapDoorBlock) {
                bottom = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_bottom"));
                top = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_top"));
                ModelFile.ExistingModelFile open = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name + "_open"));
                this.trapdoorBlock((TrapDoorBlock)block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, true);
                continue;
            }
            if (block instanceof VerticalSlabBlock) {
                ModelFile.ExistingModelFile slab = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name));
                ModelFile.ExistingModelFile doubleSlab = this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name, "_vertical_slab", "_planks"));
                this.getVariantBuilder(block).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalSlabType.NORTH)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 0, true)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalSlabType.EAST)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 90, true)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalSlabType.SOUTH)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 180, true)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalSlabType.WEST)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab, 0, 270, true)}).partialState().with(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabBlock.VerticalSlabType.DOUBLE)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlab)});
                continue;
            }
            if (block instanceof FairyRingBlock) continue;
            this.simpleBlock(block, (ModelFile)this.models().getExistingFile(BlockStateProvider.getBlockResourceLocation(name)));
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$2(ModelFile plate_down, ModelFile plate, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? plate_down : plate).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$1(ModelFile ladder, BlockState state) {
        return ConfiguredModel.builder().modelFile(ladder).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$0(ModelFile pressed_button, ModelFile button, BlockState state) {
        int xRot = 0;
        AttachFace face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
        if (face == AttachFace.WALL) {
            xRot = 90;
        } else if (face == AttachFace.CEILING) {
            xRot = 180;
        }
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? pressed_button : button).uvLock(face == AttachFace.WALL).rotationX(xRot).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build();
    }
}

