/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data;

import cech12.extendedmushrooms.api.block.ExtendedMushroomsBlocks;
import cech12.extendedmushrooms.api.item.ExtendedMushroomsItems;
import cech12.extendedmushrooms.block.BookshelfBlock;
import cech12.extendedmushrooms.block.FairyRingBlock;
import cech12.extendedmushrooms.block.mushroomblocks.MushroomStemBlock;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.ibm.icu.impl.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.IntClamper;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.Inverted;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LimitCount;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockLootProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(DataGenerator generator) {
        this.generator = generator;
        for (Block block2 : ForgeRegistries.BLOCKS) {
            if (!"extendedmushrooms".equals(block2.getRegistryName().func_110624_b())) continue;
            if (block2 instanceof BookshelfBlock) {
                this.functionTable.put(block2, BlockLootProvider::dropBookshelf);
                continue;
            }
            if (block2 instanceof SlabBlock) {
                this.functionTable.put(block2, BlockLootProvider::dropSlab);
                continue;
            }
            if (block2 instanceof DoorBlock) {
                this.functionTable.put(block2, BlockLootProvider::dropDoor);
                continue;
            }
            if (block2 instanceof MushroomStemBlock) {
                this.functionTable.put(block2, BlockLootProvider::dropStem);
                continue;
            }
            if (!(block2 instanceof FairyRingBlock)) continue;
            this.functionTable.put(block2, BlockLootProvider::dropNothing);
        }
        this.functionTable.put(ExtendedMushroomsBlocks.GLOWSHROOM_CAP, block -> BlockLootProvider.dropCap(block, (IItemProvider)ExtendedMushroomsBlocks.GLOWSHROOM, Pair.of((Object)ExtendedMushroomsItems.GLOWSTONE_CRUMBS, (Object)new float[]{0.5f, 0.6f, 0.7f, 0.8f, 0.9f})));
        this.functionTable.put(ExtendedMushroomsBlocks.POISONOUS_MUSHROOM_CAP, block -> BlockLootProvider.dropCap(block, (IItemProvider)ExtendedMushroomsBlocks.POISONOUS_MUSHROOM, new Pair[0]));
        this.functionTable.put(ExtendedMushroomsBlocks.SLIME_FUNGUS_CAP, block -> BlockLootProvider.dropCap(block, (IItemProvider)ExtendedMushroomsBlocks.SLIME_FUNGUS, Pair.of((Object)ExtendedMushroomsItems.SLIME_BLOB, (Object)new float[]{0.5f, 0.6f, 0.7f, 0.8f, 0.9f})));
        this.functionTable.put(ExtendedMushroomsBlocks.HONEY_FUNGUS_CAP, block -> BlockLootProvider.dropCap(block, (IItemProvider)ExtendedMushroomsBlocks.HONEY_FUNGUS, Pair.of((Object)ExtendedMushroomsItems.HONEY_BLOB, (Object)new float[]{0.5f, 0.6f, 0.7f, 0.8f, 0.9f}), Pair.of((Object)ExtendedMushroomsItems.HONEYCOMB_SHRED, (Object)new float[]{0.5f, 0.6f, 0.7f, 0.8f, 0.9f})));
        this.functionTable.put(ExtendedMushroomsBlocks.INFESTED_GRASS, BlockLootProvider::dropOnlyWithShears);
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/loot_tables/blocks/" + id.func_110623_a() + ".json");
    }

    private static LootTable.Builder dropNothing(Block b) {
        return LootTable.func_216119_b();
    }

    private static LootTable.Builder dropItself(Block block) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block);
        LootPool.Builder pool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static LootTable.Builder dropOnlyWithShears(Block block) {
        AlternativesLootEntry.Builder entry = AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.SHEARS)))});
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    private static LootTable.Builder dropSlab(Block block) {
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    private static LootTable.Builder dropDoor(Block block) {
        LootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)));
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(entry).func_212840_b_(SurvivesExplosion.func_215968_b()));
    }

    private static LootTable.Builder dropStem(Block block) {
        ItemPredicate.Builder silkPredicate = ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)));
        StandaloneLootEntry.Builder entry = ItemLootEntry.func_216168_a((IItemProvider)block);
        LootPool.Builder lootPool = LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)silkPredicate));
        return LootTable.func_216119_b().func_216040_a(lootPool);
    }

    @SafeVarargs
    private static LootTable.Builder dropCap(Block block, IItemProvider mushroom, Pair<IItemProvider, float[]> ... additionalLoot) {
        ItemPredicate.Builder silkPredicate = ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)));
        LootEntry.Builder silkTouchAlternative = ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)silkPredicate));
        StandaloneLootEntry.Builder decayAlternative = ItemLootEntry.func_216168_a((IItemProvider)mushroom).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)-6.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LimitCount.func_215911_a((IntClamper)IntClamper.func_215848_a((int)0))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        AlternativesLootEntry.Builder entry = AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{silkTouchAlternative, decayAlternative});
        LootTable.Builder lootTable = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
        if (additionalLoot != null) {
            for (Pair<IItemProvider, float[]> pair : additionalLoot) {
                IItemProvider lootItem = (IItemProvider)pair.first;
                float[] fortuneChances = (float[])pair.second;
                StandaloneLootEntry.Builder additionalEntry = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)lootItem).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])fortuneChances))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
                LootPool.Builder additionalLootPool = LootPool.func_216096_a().name("additional").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)additionalEntry).func_212840_b_(Inverted.func_215979_a((ILootCondition.IBuilder)Alternative.func_215960_a((ILootCondition.IBuilder[])new ILootCondition.IBuilder[]{MatchTool.func_216012_a((ItemPredicate.Builder)silkPredicate)})));
                lootTable.func_216040_a(additionalLootPool);
            }
        }
        return lootTable;
    }

    private static LootTable.Builder dropBookshelf(Block block) {
        ItemPredicate.Builder silkPredicate = ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)));
        LootEntry.Builder silkTouchAlternative = ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)silkPredicate));
        StandaloneLootEntry.Builder dropBooksAlternative = ItemLootEntry.func_216168_a((IItemProvider)Items.field_151122_aG).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)3))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
        AlternativesLootEntry.Builder entry = AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{silkTouchAlternative, dropBooksAlternative});
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)entry));
    }

    public void func_200398_a(@Nonnull DirectoryCache cache) throws IOException {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!"extendedmushrooms".equals(block.getRegistryName().func_110624_b()) || block instanceof FlowerPotBlock) continue;
            Function<Block, LootTable.Builder> func = this.functionTable.getOrDefault(block, BlockLootProvider::dropItself);
            tables.put(block.getRegistryName(), func.apply(block));
        }
        for (Map.Entry e : tables.entrySet()) {
            Path path = BlockLootProvider.getPath(this.generator.func_200391_b(), (ResourceLocation)e.getKey());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)((LootTable.Builder)e.getValue()).func_216039_a(LootParameterSets.field_216267_h).func_216038_b()), (Path)path);
        }
    }

    @Nonnull
    public String func_200397_b() {
        return "Extended Mushrooms block loot tables";
    }
}

