/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.compat;

import cech12.extendedmushrooms.compat.ModCompat;
import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ModFeatureEnabledCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("extendedmushrooms", "mod_feature_enabled");
    private final String feature;
    private final boolean inverted;

    public ModFeatureEnabledCondition(String feature) {
        this.feature = feature;
        this.inverted = false;
    }

    public ModFeatureEnabledCondition(String feature, boolean inverted) {
        this.feature = feature;
        this.inverted = inverted;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test() {
        switch (this.feature) {
            case "variantBookshelves": {
                return this.inverted != ModCompat.isVariantBookshelvesModLoaded();
            }
            case "variantChests": {
                return this.inverted != ModCompat.isVariantChestsModLoaded();
            }
            case "variantTrappedChests": {
                return this.inverted != ModCompat.isVariantTrappedChestsModLoaded();
            }
            case "variantLadders": {
                return this.inverted != ModCompat.isVariantLaddersModLoaded();
            }
            case "verticalPlanks": {
                return this.inverted != ModCompat.isVerticalPlanksModLoaded();
            }
            case "verticalSlabs": {
                return this.inverted != ModCompat.isVerticalSlabsModLoaded();
            }
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<ModFeatureEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ModFeatureEnabledCondition value) {
            json.addProperty("feature", value.feature);
            if (value.inverted) {
                json.addProperty("inverted", Boolean.valueOf(true));
            }
        }

        public ModFeatureEnabledCondition read(JsonObject json) {
            return new ModFeatureEnabledCondition(JSONUtils.func_151200_h((JsonObject)json, (String)"feature"), JSONUtils.func_151209_a((JsonObject)json, (String)"inverted", (boolean)false));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

